/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap.mapping;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.ow2.opensuit.xmlmap.mapping.FieldMapping;
import org.ow2.opensuit.xmlmap.mapping.MappingError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementMapping {
    private static final FieldMapping[] MAPPED_ARRAY_TYPE = new FieldMapping[0];
    private Constructor<?> defaultCS;
    private List<?> mappings;
    private Class<?> clazz;
    private MappingError[] errors;

    protected ElementMapping(Class<?> mappedClass, Constructor<?> iCS, List<?> mappings, MappingError[] mappingErrors) {
        this.clazz = mappedClass;
        if (mappingErrors != null) {
            this.errors = (MappingError[])mappingErrors.clone();
        }
        this.defaultCS = iCS;
        this.mappings = mappings;
    }

    public Class<?> getMappedClass() {
        return this.clazz;
    }

    public MappingError[] getMappingErrors() {
        return this.errors;
    }

    public Constructor<?> getDefaultConstructor() {
        return this.defaultCS;
    }

    public FieldMapping[] getMappings(int iTypes) {
        if (iTypes == 0) {
            return this.mappings.toArray(MAPPED_ARRAY_TYPE);
        }
        ArrayList<FieldMapping> ret = new ArrayList<FieldMapping>();
        for (int i = 0; i < this.mappings.size(); ++i) {
            FieldMapping mapping = (FieldMapping)this.mappings.get(i);
            if ((mapping.getType() & iTypes) == 0) continue;
            ret.add(mapping);
        }
        return ret.toArray(MAPPED_ARRAY_TYPE);
    }

    public FieldMapping getMappingByNameAndType(String iName, int iType) {
        for (int i = 0; i < this.mappings.size(); ++i) {
            FieldMapping mapping = (FieldMapping)this.mappings.get(i);
            if (mapping.getType() != iType || !mapping.getName().equals(iName)) continue;
            return mapping;
        }
        return null;
    }

    public FieldMapping getCollectedMapping(Class<?> iClass) {
        for (int i = 0; i < this.mappings.size(); ++i) {
            FieldMapping mapping = (FieldMapping)this.mappings.get(i);
            if (mapping.getType() != 4 || !mapping.getBaseClass().isAssignableFrom(iClass)) continue;
            return mapping;
        }
        return null;
    }
}

