/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap.mapping;

import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldMapping {
    public static final int ATTRIBUTE = 1;
    public static final int CHILD_ELT = 2;
    public static final int DIRECT_CHILD_ELT = 4;
    public static final int CONTENT = 8;
    public static final int ANCESTOR = 64;
    private Field field;
    private int type;
    private String name;
    private int minOccurs = 1;
    private int maxOccurs = 1;

    public FieldMapping(Field field) {
        this.field = field;
    }

    public String toString() {
        if (this.type == 1) {
            return this.field.getName() + ": " + (this.minOccurs == 0 ? "optional" : "required") + " attribute '" + this.name + "' of type " + this.field.getType().getName();
        }
        if (this.type == 8) {
            return this.field.getName() + ": HTML content";
        }
        if (this.field.getType().isArray() && this.field.getType() != byte[].class) {
            return this.field.getName() + ": " + (this.type == 2 ? "indirect children '" + this.name + "'" : "direct children") + " [" + this.minOccurs + "," + (this.maxOccurs == Integer.MAX_VALUE ? "unbounded" : String.valueOf(this.maxOccurs)) + "] of type " + this.field.getType().getComponentType().getName();
        }
        return this.field.getName() + ": " + (this.minOccurs == 0 ? "optional" : "required") + " " + (this.type == 2 ? "indirect child '" + this.name + "'" : "direct child") + " of type " + this.field.getType().getName();
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Field getField() {
        return this.field;
    }

    public Class<?> getBaseClass() {
        return this.field.getType().isArray() && this.field.getType() != byte[].class ? this.field.getType().getComponentType() : this.field.getType();
    }

    public boolean isUseRequired() {
        return this.minOccurs > 0;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }
}

