/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap.mapping;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ow2.opensuit.xmlmap.interfaces.IContentAssist;
import org.ow2.opensuit.xmlmap.mapping.ElementMapping;
import org.ow2.opensuit.xmlmap.mapping.FieldMapping;
import org.ow2.opensuit.xmlmap.mapping.MappingError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IMappingMethod {
    private static final MappingError[] MAPPING_ERROR_ARRAY_TYPE = new MappingError[0];
    private static Map<String, ElementMapping> class2Mappings = new HashMap<String, ElementMapping>();

    public abstract boolean isSimpleType(Class<?> var1);

    public abstract boolean isXmlElement(Class<?> var1);

    public abstract boolean isSubstitutionGroup(Class<?> var1);

    public abstract boolean isEnumeration(Class<?> var1);

    public abstract boolean isImportable(Class<?> var1);

    protected abstract void populateMappings(List<?> var1, List<?> var2, Class<?> var3, Class<?> var4);

    public abstract Class<?> getBaseSimpleType(Class<?> var1);

    public final ElementMapping getElementMappings(Class<?> iClass, boolean iGetInherited) {
        ElementMapping mappings;
        String key = iClass.getName();
        if (iGetInherited) {
            key = "(full)@" + key;
        }
        if ((mappings = class2Mappings.get(key)) == null) {
            ArrayList mappedFields = new ArrayList();
            ArrayList<MappingError> mappingErrors = new ArrayList<MappingError>();
            Constructor<?> cs = null;
            if (this.isXmlElement(iClass) && (iClass.getModifiers() & 0x400) == 0) {
                try {
                    cs = iClass.getConstructor(new Class[0]);
                    if (cs == null) {
                        mappingErrors.add(new MappingError("Class '" + iClass.getName() + "' has no default constructor."));
                    }
                }
                catch (SecurityException e) {
                    mappingErrors.add(new MappingError("SecurityError while retrieveing '" + iClass.getName() + "' default constructor: " + e.getMessage()));
                }
                catch (NoSuchMethodException e) {
                    mappingErrors.add(new MappingError("Class '" + iClass.getName() + "' has no default constructor."));
                }
            }
            Class excludeFromClass = iGetInherited ? Object.class : iClass.getSuperclass();
            this.populateMappings(mappedFields, mappingErrors, iClass, excludeFromClass);
            MappingError[] errors = mappingErrors.toArray(MAPPING_ERROR_ARRAY_TYPE);
            mappings = new ElementMapping(iClass, cs, mappedFields, errors);
            class2Mappings.put(key, mappings);
        }
        return mappings;
    }

    public abstract int getNbOfEnumItems(Class<?> var1);

    public abstract Object getEnumItem(Class<?> var1, String var2);

    public abstract Object getEnumItem(Class<?> var1, int var2);

    public abstract String getEnumItemName(Class<?> var1, int var2);

    public abstract String getEnumItemName(Object var1);

    public abstract String getInstanceName(Locale var1, Object var2);

    public abstract String getElementTitle(Locale var1, Class<?> var2);

    public abstract String getElementDetails(Locale var1, Class<?> var2);

    public abstract String getMappingTitle(Locale var1, FieldMapping var2);

    public abstract String getMappingDetails(Locale var1, FieldMapping var2);

    public abstract String getEnumItemDetails(Locale var1, Class<?> var2, String var3);

    public abstract IContentAssist getContentAssist(Object var1, FieldMapping var2);
}

