/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.opensuit.xmlmap.impl.SchemaImpl;
import org.ow2.opensuit.xmlmap.schema.ISchema;
import org.ow2.opensuit.xmlmap.schema.ISchemaElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemasManager {
    private static final ISchema[] SCHEMAS_ARRAY_TYPE = new ISchema[0];
    private static final ISchemaElement[] ELTS_ARRAY_TYPE = new ISchemaElement[0];
    private List<ISchema> schemas = new ArrayList<ISchema>();
    private Map<Class<?>, ISchemaElement[]> interface2Implementors = new HashMap();
    private ClassLoader classLoader = SchemaImpl.class.getClassLoader();

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ISchema declareSchema(String iName, String iLocator, String iPackage) {
        ISchema schema = this.getSchema(iPackage);
        if (schema == null) {
            schema = new SchemaImpl(this, iName, iLocator, iPackage);
            this.schemas.add(schema);
        }
        return schema;
    }

    public ISchema getSchema(String iPackage) {
        for (int i = 0; i < this.schemas.size(); ++i) {
            ISchema schema = this.schemas.get(i);
            if (!iPackage.equals(schema.getRootPackage())) continue;
            return schema;
        }
        return null;
    }

    public void buildAllFromClassPath() throws Exception {
        for (int i = 0; i < this.schemas.size(); ++i) {
            SchemaImpl schema = (SchemaImpl)this.schemas.get(i);
            schema.buildFromClassPath();
        }
    }

    public ISchema[] getAllSchemas() {
        return this.schemas.toArray(SCHEMAS_ARRAY_TYPE);
    }

    public ISchemaElement getElement(Class<?> iClass) {
        SchemaImpl schema = (SchemaImpl)this.getDeclaringSchema(iClass);
        if (schema == null) {
            return null;
        }
        return schema.getElement(iClass);
    }

    public ISchemaElement[] getAllImplementors(Class<?> iSubstitutionGroup) {
        ISchemaElement[] implementors = this.interface2Implementors.get(iSubstitutionGroup);
        if (implementors == null) {
            ArrayList<ISchemaElement> implementorsVect = new ArrayList<ISchemaElement>();
            for (int i = 0; i < this.schemas.size(); ++i) {
                ISchema schema = this.schemas.get(i);
                ISchemaElement[] elements = schema.getAllElements();
                for (int j = 0; j < elements.length; ++j) {
                    if (elements[j].getMappedClass().isInterface() || (elements[j].getMappedClass().getModifiers() & 0x400) != 0 || !iSubstitutionGroup.isAssignableFrom(elements[j].getMappedClass())) continue;
                    implementorsVect.add(elements[j]);
                }
            }
            implementors = implementorsVect.toArray(ELTS_ARRAY_TYPE);
            this.interface2Implementors.put(iSubstitutionGroup, implementors);
        }
        return implementors;
    }

    public ISchema getDeclaringSchema(Class<?> iClass) {
        String classname = iClass.getName();
        int lastDotIdx = classname.lastIndexOf(46);
        if (lastDotIdx < 0) {
            return null;
        }
        String pack = classname.substring(0, lastDotIdx);
        if (this.schemas != null) {
            for (int i = 0; i < this.schemas.size(); ++i) {
                ISchema schema = this.schemas.get(i);
                if (!pack.startsWith(schema.getRootPackage())) continue;
                return schema;
            }
        }
        return null;
    }
}

