/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap.tests;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TestSAX {
    private URL mainDoc;

    public static void main(String[] args) throws MalformedURLException, SAXException, IOException, ParserConfigurationException {
        File f = new File("C:/Dev/EclipseProj/samples/movies_db/src/main/webapp/WEB-INF/MoviesDBApp.xml");
        TestSAX.instantiate(f.toURL());
    }

    private TestSAX(URL iMainDocUrl) {
        this.mainDoc = iMainDocUrl;
    }

    public static final TestSAX instantiate(URL iXmlFileUrl) throws SAXException, IOException, ParserConfigurationException {
        TestSAX doc = new TestSAX(iXmlFileUrl);
        doc.instantiateMainDoc();
        return doc;
    }

    private void instantiateMainDoc() throws SAXException, IOException, ParserConfigurationException {
        InputStream in = this.mainDoc.openStream();
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        SAXParser parser = parserFactory.newSAXParser();
        parser.parse(in, (DefaultHandler)new SAXHandler());
        in.close();
    }

    private class SAXHandler
    extends DefaultHandler {
        private Locator locator = null;
        private Vector infoAncestors = new Vector();

        private SAXHandler() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private void trace(String message) {
            if (this.locator == null) {
                System.out.println("[?] " + message);
            } else {
                System.out.println("[l" + this.locator.getLineNumber() + " c" + this.locator.getColumnNumber() + "] " + message);
            }
        }

        public void startDocument() throws SAXException {
            this.trace("startDocument()");
        }

        public void endDocument() throws SAXException {
            this.trace("endDocument()");
        }

        public void startElement(String uri, String localName, String name, Attributes attribs) throws SAXException {
            this.trace("startElement('" + uri + "', '" + localName + "', '" + name + "')");
        }

        public void characters(char[] chars, int start, int length) throws SAXException {
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            this.trace("endElement('" + uri + "', '" + localName + "', '" + name + "')");
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.trace("startPrefixMapping('" + prefix + "', '" + uri + "')");
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.trace("endPrefixMapping('" + prefix + "')");
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.trace("ignorableWhitespace(): " + length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.trace("processingInstruction('" + target + "', '" + data + "')");
        }

        public void skippedEntity(String name) throws SAXException {
            this.trace("skippedEntity('" + name + "')");
        }

        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
            this.trace("notationDecl('" + name + "', '" + publicId + "', '" + systemId + "')");
            super.notationDecl(name, publicId, systemId);
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
            this.trace("unparsedEntityDecl('" + name + "', '" + publicId + "', '" + systemId + "')");
            super.unparsedEntityDecl(name, publicId, systemId, notationName);
        }

        public void error(SAXParseException e) throws SAXException {
            this.trace("error('" + e.getMessage() + "')");
            super.error(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.trace("fatalError('" + e.getMessage() + "')");
            super.fatalError(e);
        }

        public void warning(SAXParseException e) throws SAXException {
            this.trace("warning('" + e.getMessage() + "')");
            super.warning(e);
        }
    }
}

