/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XML2HTML {
    private PrintWriter writer;

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException {
        if (args.length < 1) {
            System.out.println("Usage: XML2HTML <input xml file or dir> [output file or dir]");
            return;
        }
        File inXmlFile = new File(args[0]);
        if (!inXmlFile.exists()) {
            System.out.println("File [" + args[0] + "] not found.");
            return;
        }
        File inXmlDir = inXmlFile.isDirectory() ? inXmlFile : inXmlFile.getParentFile();
        File outHtmlFile = null;
        if (args.length > 1) {
            outHtmlFile = new File(args[1]);
        }
        if (inXmlFile.isFile()) {
            if (outHtmlFile == null) {
                outHtmlFile = new File(inXmlFile.getParentFile(), inXmlFile.getName().replace('.', '_') + ".html");
            } else if (outHtmlFile.exists() && outHtmlFile.isDirectory()) {
                outHtmlFile = new File(outHtmlFile, inXmlFile.getName().replace('.', '_') + ".html");
            }
            new XML2HTML().format(inXmlFile, outHtmlFile);
        } else {
            File outHtmlDir = inXmlDir;
            if (outHtmlFile != null) {
                if (!outHtmlFile.exists()) {
                    outHtmlFile.mkdirs();
                }
                if (outHtmlFile.exists() && outHtmlFile.isDirectory()) {
                    outHtmlDir = outHtmlFile;
                }
            }
            new XML2HTML().recurFormat(inXmlDir, outHtmlDir);
        }
    }

    private void recurFormat(File inXmlDir, File outHtmlDir) {
        File[] files = inXmlDir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (f.isDirectory()) {
                    this.recurFormat(f, new File(outHtmlDir, f.getName()));
                    continue;
                }
                if (!f.getName().endsWith(".xml")) continue;
                File outHtmlFile = new File(outHtmlDir, f.getName().replace('.', '_') + ".html");
                try {
                    this.format(f, outHtmlFile);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error occured while formatting file " + f);
                    e.printStackTrace();
                }
            }
        }
    }

    private void format(File inXmlFile, File outHtmlFile) throws FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        outHtmlFile.getParentFile().mkdirs();
        this.format(new FileInputStream(inXmlFile), new FileOutputStream(outHtmlFile));
    }

    public void format(InputStream input, OutputStream output) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        SAXParser parser = parserFactory.newSAXParser();
        this.writer = new PrintWriter(output);
        SAXHandler handler = new SAXHandler(this.writer);
        parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        this.openHtml();
        parser.parse(input, (DefaultHandler)handler);
        this.closeHtml();
        this.writer.flush();
        this.writer.close();
        input.close();
    }

    private void openHtml() {
        this.writer.println("<html>");
        this.writer.println("<head>");
        this.writer.println("</head>");
        this.writer.println("<style type='text/css'>");
        this.writer.println("pre.XML {");
        this.writer.println("\tfont-family: courier;");
        this.writer.println("\tfont-size: 9pt;");
        this.writer.println("\tbackground-color: #FFFFFF;");
        this.writer.println("}");
        this.writer.println("span.Element {");
        this.writer.println("\tcolor: #3F7F7F;");
        this.writer.println("}");
        this.writer.println("span.AttrName {");
        this.writer.println("\tcolor: #7F007F;");
        this.writer.println("}");
        this.writer.println("span.AttrValue {");
        this.writer.println("\tcolor: #2A00FF;");
        this.writer.println("}");
        this.writer.println("span.Comment {");
        this.writer.println("\tcolor: #3F5FBF;");
        this.writer.println("}");
        this.writer.println("span.Text {");
        this.writer.println("\tcolor: #000000;");
        this.writer.println("}");
        this.writer.println("</style>");
        this.writer.println("<body>");
        this.writer.println("<pre class='XML'>");
    }

    private void closeHtml() {
        this.writer.println("</pre>");
        this.writer.println("</body>");
        this.writer.println("</html>");
    }

    public static String encode2HTML(char[] text, int start, int len, boolean iNBSP) {
        int nbChars = len;
        StringBuffer sb = new StringBuffer(nbChars);
        block10: for (int i = 0; i < len; ++i) {
            char c = text[start + i];
            if (iNBSP && c == ' ') {
                sb.append("&nbsp;");
                continue;
            }
            switch (c) {
                case '\n': {
                    sb.append("\n");
                    continue block10;
                }
                case '\r': {
                    continue block10;
                }
                case '\t': {
                    sb.append("    ");
                    continue block10;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block10;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block10;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block10;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block10;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static class Element {
        String uri;
        String localName;
        String name;
        Attributes attribs;

        public Element(String uri, String localName, String name, Attributes attribs) {
            this.uri = uri;
            this.localName = localName;
            this.name = name;
            this.attribs = attribs;
        }
    }

    private class SAXHandler
    extends DefaultHandler
    implements LexicalHandler {
        private Element openedElt;
        private PrintWriter htmlOutput;
        private Locator locator = null;

        public SAXHandler(PrintWriter htmlOutput) {
            this.htmlOutput = htmlOutput;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private void trace(String message) {
        }

        public void startDocument() throws SAXException {
            this.trace("startDocument()");
        }

        public void endDocument() throws SAXException {
            this.trace("endDocument()");
        }

        private boolean flushElement(boolean inline) {
            if (this.openedElt == null) {
                return false;
            }
            XML2HTML.this.writer.print("<span class='Element'>");
            XML2HTML.this.writer.print("&lt;");
            XML2HTML.this.writer.print(this.openedElt.name);
            if (this.openedElt.attribs != null) {
                for (int i = 0; i < this.openedElt.attribs.getLength(); ++i) {
                    XML2HTML.this.writer.print(" ");
                    XML2HTML.this.writer.print("<span class='AttrName'>");
                    XML2HTML.this.writer.print(this.openedElt.attribs.getLocalName(i));
                    XML2HTML.this.writer.print("</span>");
                    XML2HTML.this.writer.print("=");
                    XML2HTML.this.writer.print("<span class='AttrValue'>");
                    XML2HTML.this.writer.print("\"");
                    XML2HTML.this.writer.print(this.openedElt.attribs.getValue(i));
                    XML2HTML.this.writer.print("\"");
                    XML2HTML.this.writer.print("</span>");
                }
            }
            if (inline) {
                XML2HTML.this.writer.print("/&gt;");
                XML2HTML.this.writer.print("</span>");
            } else {
                XML2HTML.this.writer.print("&gt;");
            }
            this.openedElt = null;
            return true;
        }

        public void startElement(String uri, String localName, String name, Attributes attribs) throws SAXException {
            this.trace("startElement('" + uri + "', '" + localName + "', '" + name + "')");
            this.flushElement(false);
            this.openedElt = new Element(uri, localName, name, attribs);
        }

        public void characters(char[] chars, int start, int length) throws SAXException {
            boolean hasText;
            this.trace("characters: \"" + new String(chars, start, length) + "\" (" + length + ")");
            this.flushElement(false);
            boolean bl = hasText = !this.isWhitespaces(chars, start, length);
            if (hasText) {
                this.htmlOutput.write("<span class='Text'>");
            }
            this.htmlOutput.write(XML2HTML.encode2HTML(chars, start, length, false));
            if (hasText) {
                this.htmlOutput.write("</span>");
            }
        }

        private boolean isWhitespaces(char[] chars, int start, int length) {
            for (int i = 0; i < length; ++i) {
                if (Character.isWhitespace(chars[i + start])) continue;
                return false;
            }
            return true;
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            this.trace("endElement('" + uri + "', '" + localName + "', '" + name + "')");
            if (!this.flushElement(true)) {
                XML2HTML.this.writer.print("&lt;/");
                XML2HTML.this.writer.print(name);
                XML2HTML.this.writer.print("&gt;");
                XML2HTML.this.writer.print("</span>");
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.trace("startPrefixMapping('" + prefix + "', '" + uri + "')");
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.trace("endPrefixMapping('" + prefix + "')");
        }

        public void ignorableWhitespace(char[] chars, int start, int length) throws SAXException {
            this.trace("ignorableWhitespace(): " + length);
            this.flushElement(false);
            this.htmlOutput.write(XML2HTML.encode2HTML(chars, start, length, false));
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.trace("processingInstruction('" + target + "', '" + data + "')");
        }

        public void skippedEntity(String name) throws SAXException {
            this.trace("skippedEntity('" + name + "')");
        }

        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
            this.trace("notationDecl('" + name + "', '" + publicId + "', '" + systemId + "')");
            super.notationDecl(name, publicId, systemId);
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
            this.trace("unparsedEntityDecl('" + name + "', '" + publicId + "', '" + systemId + "')");
            super.unparsedEntityDecl(name, publicId, systemId, notationName);
        }

        public void error(SAXParseException e) throws SAXException {
            this.trace("error('" + e.getMessage() + "')");
            super.error(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.trace("fatalError('" + e.getMessage() + "')");
            super.fatalError(e);
        }

        public void warning(SAXParseException e) throws SAXException {
            this.trace("warning('" + e.getMessage() + "')");
            super.warning(e);
        }

        public void comment(char[] chars, int start, int length) throws SAXException {
            this.trace("comment: [" + new String(chars, start, length) + "]");
            this.flushElement(false);
            XML2HTML.this.writer.print("<span class='Comment'>&lt;!--");
            XML2HTML.this.writer.print(XML2HTML.encode2HTML(chars, start, length, false));
            XML2HTML.this.writer.print("--&gt;</span>");
        }

        public void startCDATA() throws SAXException {
            this.trace("startCDATA");
            this.flushElement(false);
            XML2HTML.this.writer.print("&lt;![CDATA[");
        }

        public void endCDATA() throws SAXException {
            this.trace("endCDATA");
            this.flushElement(false);
            XML2HTML.this.writer.print("]]&gt;");
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.trace("startDTD");
        }

        public void endDTD() throws SAXException {
            this.trace("endDTD");
        }

        public void startEntity(String name) throws SAXException {
            this.trace("startEntity: " + name);
        }

        public void endEntity(String name) throws SAXException {
            this.trace("endEntity: " + name);
        }
    }
}

