/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap.utils;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlHelper {
    public static void serializeXml(Node iNode, OutputStream iOutput) throws UnsupportedEncodingException, TransformerException {
        String encoding = "utf-8";
        TransformerFactory transFactory = TransformerFactory.newInstance();
        try {
            transFactory.setAttribute("indent-number", 2);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Transformer transformer = transFactory.newTransformer();
        try {
            transformer.setOutputProperty("indent", "yes");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            transformer.setOutputProperty("encoding", encoding);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        DOMSource source = new DOMSource(iNode);
        StreamResult result = new StreamResult(new OutputStreamWriter(iOutput, encoding));
        transformer.transform(source, result);
    }

    public static String getContent(Element iNode) {
        StringBuffer sb = new StringBuffer();
        XmlHelper.getContent(iNode, sb);
        return sb.toString();
    }

    private static void getContent(Element iNode, StringBuffer sb) {
        NodeList nodes = iNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n instanceof Text) {
                Text t = (Text)n;
                sb.append(t.getData());
                continue;
            }
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            sb.append("<");
            sb.append(e.getTagName());
            NamedNodeMap attrs = e.getAttributes();
            for (int j = 0; j < attrs.getLength(); ++j) {
                if (!(attrs.item(j) instanceof Attr)) continue;
                Attr a = (Attr)attrs.item(j);
                sb.append(' ');
                sb.append(a.getNodeName());
                if (a.getNodeValue() == null) continue;
                sb.append("=\"");
                sb.append(a.getNodeValue());
                sb.append("\"");
            }
            if (!e.hasChildNodes()) {
                sb.append("/>");
                continue;
            }
            sb.append(">");
            XmlHelper.getContent(e, sb);
            sb.append("</");
            sb.append(e.getTagName());
            sb.append(">");
        }
    }

    public static int getChildIndex(Element iElt) {
        Element parent = (Element)iElt.getParentNode();
        if (parent == null) {
            return -1;
        }
        int idx = 0;
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (!(n instanceof Element)) continue;
            if (n == iElt) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }
}

