/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsdHelper {
    private static final ThreadLocal<SimpleDateFormat> XML_DATE_FORMAT = new ThreadLocal();
    private static final char[] _encodeTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static SimpleDateFormat getXmlDateFormat() {
        SimpleDateFormat f = XML_DATE_FORMAT.get();
        if (f == null) {
            f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            XML_DATE_FORMAT.set(f);
        }
        return f;
    }

    public static String getSimpleType(Class<?> target) {
        if (target == Integer.TYPE || target == Integer.class) {
            return "int";
        }
        if (target == Short.TYPE || target == Short.class) {
            return "short";
        }
        if (target == Long.TYPE || target == Long.class) {
            return "long";
        }
        if (target == BigInteger.class) {
            return "integer";
        }
        if (target == Float.TYPE || target == Float.class || target == Double.TYPE || target == Double.class || target == BigDecimal.class) {
            return "decimal";
        }
        if (target == Boolean.TYPE || target == Boolean.class) {
            return "boolean";
        }
        if (target == Date.class || target == Calendar.class) {
            return "dateTime";
        }
        if (target == byte[].class) {
            return "hexBinary";
        }
        if (target == String.class) {
            return "string";
        }
        return null;
    }

    public static Object parseSimpleType(String iValue, Class<?> target) throws Exception {
        if (iValue == null) {
            return null;
        }
        if (target == Integer.TYPE || target == Integer.class) {
            BigInteger bi = new BigInteger(iValue);
            if (bi.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0 || bi.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                throw new NumberOutOfBoundsException(Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
            return bi.intValue();
        }
        if (target == Short.TYPE || target == Short.class) {
            BigInteger bi = new BigInteger(iValue);
            if (bi.compareTo(BigInteger.valueOf(-32768L)) < 0 || bi.compareTo(BigInteger.valueOf(32767L)) > 0) {
                throw new NumberOutOfBoundsException(-32768L, 32767L);
            }
            return bi.shortValue();
        }
        if (target == Long.TYPE || target == Long.class) {
            BigInteger bi = new BigInteger(iValue);
            if (bi.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0 || bi.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                throw new NumberOutOfBoundsException(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return bi.longValue();
        }
        if (target == BigInteger.class) {
            return new BigInteger(iValue);
        }
        if (target == Float.TYPE || target == Float.class) {
            return new Float(iValue);
        }
        if (target == Double.TYPE || target == Double.class) {
            return new Double(iValue);
        }
        if (target == BigDecimal.class) {
            return new BigDecimal(iValue);
        }
        if (target == Boolean.TYPE || target == Boolean.class) {
            if ("true".equalsIgnoreCase(iValue)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (target == Date.class) {
            return XsdHelper.getXmlDateFormat().parse(iValue);
        }
        if (target == Calendar.class) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(XsdHelper.getXmlDateFormat().parse(iValue));
            return cal;
        }
        if (target == String.class) {
            return iValue;
        }
        if (target == byte[].class) {
            return XsdHelper.parseHex(iValue);
        }
        return null;
    }

    public static String formatSimpleType(Object iValue, Class<?> target) {
        if (iValue == null) {
            return null;
        }
        if (target == Integer.TYPE || target == Integer.class) {
            return iValue.toString();
        }
        if (target == Short.TYPE || target == Short.class) {
            return iValue.toString();
        }
        if (target == Long.TYPE || target == Long.class) {
            return iValue.toString();
        }
        if (target == BigInteger.class) {
            return iValue.toString();
        }
        if (target == Float.TYPE || target == Float.class) {
            return iValue.toString();
        }
        if (target == Double.TYPE || target == Double.class) {
            return iValue.toString();
        }
        if (target == BigDecimal.class) {
            return iValue.toString();
        }
        if (target == Boolean.TYPE || target == Boolean.class) {
            return iValue.toString();
        }
        if (target == Date.class) {
            return XsdHelper.getXmlDateFormat().format(iValue);
        }
        if (target == Calendar.class) {
            return XsdHelper.getXmlDateFormat().format(((Calendar)iValue).getTime());
        }
        if (target == String.class) {
            return (String)iValue;
        }
        if (target == byte[].class) {
            return XsdHelper.formatHex((byte[])iValue);
        }
        return null;
    }

    private static final byte[] parseHex(String iString) throws Exception {
        if (iString == null) {
            return null;
        }
        if (iString.length() % 2 != 0) {
            throw new Exception("Not an Hexadecimal string: " + iString);
        }
        char[] string = iString.toCharArray();
        byte[] result = new byte[iString.length() / 2];
        for (int i = 0; i < result.length; ++i) {
            int high = XsdHelper.getHexValue(string[i * 2]);
            int low = XsdHelper.getHexValue(string[i * 2 + 1]);
            result[i] = (byte)((high << 4) + low);
        }
        return result;
    }

    private static int getHexValue(char iChar) throws Exception {
        if (iChar >= '0' && iChar <= '9') {
            return iChar - 48;
        }
        if (iChar >= 'a' && iChar <= 'f') {
            return iChar - 97 + 10;
        }
        if (iChar >= 'A' && iChar <= 'F') {
            return iChar - 65 + 10;
        }
        throw new Exception("Not an hexadecimal character: '" + iChar + "'.");
    }

    private static final String formatHex(byte[] iData) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < iData.length; ++i) {
            int b = iData[i];
            if (b < 0) {
                b += 256;
            }
            result.append(_encodeTable[b >> 4]);
            result.append(_encodeTable[b & 0xF]);
        }
        return result.toString();
    }

    public static class NumberOutOfBoundsException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 3970942123298760410L;
        private long min;
        private long max;

        public NumberOutOfBoundsException(long min, long max) {
            this.min = min;
            this.max = max;
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }
    }
}

