/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap.utils.minidom;

import org.ow2.opensuit.xmlmap.utils.minidom.XmlAttribute;
import org.ow2.opensuit.xmlmap.utils.minidom.XmlElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomBuilder {
    public static XmlElement build(Document doc) {
        return DomBuilder.build(doc.getDocumentElement());
    }

    private static XmlElement build(Element e) {
        NodeList children;
        XmlElement elt = new XmlElement(e.getNamespaceURI(), e.getLocalName(), e.getNodeName());
        NamedNodeMap attrs = e.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr a = (Attr)attrs.item(i);
                XmlAttribute attr = new XmlAttribute(a.getNamespaceURI(), a.getLocalName(), a.getName(), a.getValue());
                elt.addAttribute(attr);
            }
        }
        if ((children = e.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node n = children.item(i);
                if (n instanceof Element) {
                    elt.addChild(DomBuilder.build((Element)n));
                    continue;
                }
                if (!(n instanceof Text)) continue;
                String txt = ((Text)n).getNodeValue();
                elt.appendContent(txt.toCharArray(), 0, txt.length());
            }
        }
        return elt;
    }
}

