/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap.utils.minidom;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.ow2.opensuit.xmlmap.utils.minidom.XmlAttribute;
import org.ow2.opensuit.xmlmap.utils.minidom.XmlElement;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Parser {
    public static final XmlElement parse(URL document) throws IOException, SAXException, ParserConfigurationException, FactoryConfigurationError {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        SAXParser parser = parserFactory.newSAXParser();
        InputSource input = new InputSource(document.toExternalForm());
        SAXHandler hdl = new SAXHandler();
        parser.parse(input, (DefaultHandler)hdl);
        return hdl.getDocumentElement().getFirstChild();
    }

    private static class SAXHandler
    extends DefaultHandler {
        private Locator locator = null;
        private List<XmlElement> ancestors = new ArrayList<XmlElement>();

        private SAXHandler() {
        }

        private void startElement(XmlElement elt) {
            XmlElement parent = this.getCurElement();
            if (parent != null) {
                parent.addChild(elt);
            }
            this.ancestors.add(elt);
        }

        private void endElement() {
            if (this.ancestors.size() > 1) {
                this.ancestors.remove(this.ancestors.size() - 1);
            }
        }

        private XmlElement getDocumentElement() {
            return this.ancestors.get(0);
        }

        private XmlElement getCurElement() {
            if (this.ancestors.size() == 0) {
                return null;
            }
            return this.ancestors.get(this.ancestors.size() - 1);
        }

        private void trace(String message) {
        }

        public void setDocumentLocator(Locator locator) {
            this.trace("document locator: " + locator.getPublicId() + "/" + locator.getSystemId());
            this.locator = locator;
        }

        public void startDocument() throws SAXException {
            this.trace("startDocument()");
            XmlElement elt = new XmlElement(null, null, null);
            this.startElement(elt);
        }

        public void endDocument() throws SAXException {
            this.trace("endDocument()");
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.trace("startElement('" + uri + "', '" + localName + "', '" + name + "')");
            XmlElement elt = new XmlElement(uri, localName, name);
            if (this.locator != null) {
                elt.setLocation(this.locator.getLineNumber(), this.locator.getColumnNumber());
            }
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    XmlAttribute attr = new XmlAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getValue(i));
                    elt.addAttribute(attr);
                }
            }
            this.startElement(elt);
        }

        public void characters(char[] chars, int start, int length) throws SAXException {
            this.getCurElement().appendContent(chars, start, length);
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            this.trace("endElement('" + uri + "', '" + localName + "', '" + name + "')");
            this.endElement();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.trace("startPrefixMapping('" + prefix + "', '" + uri + "')");
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.trace("endPrefixMapping('" + prefix + "')");
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.trace("ignorableWhitespace(): " + length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.trace("processingInstruction('" + target + "', '" + data + "')");
        }

        public void skippedEntity(String name) throws SAXException {
            this.trace("skippedEntity('" + name + "')");
        }
    }
}

