/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap.utils.minidom;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.ow2.opensuit.xmlmap.utils.minidom.XmlAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlElement {
    private String namespaceURI;
    private String localName;
    private String tagName;
    private HashMap<String, XmlAttribute> attributes;
    private StringBuffer content;
    private List<XmlElement> children;
    private int line = -1;
    private int col = -1;

    public XmlElement(String uri, String localName, String name) {
        this.namespaceURI = uri;
        this.localName = localName;
        this.tagName = name;
    }

    public void setLocation(int line, int col) {
        this.line = line;
        this.col = col;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public void addChild(XmlElement iNode) {
        if (iNode == null) {
            return;
        }
        if (this.children == null) {
            this.children = new Vector<XmlElement>(1);
        }
        this.children.add(iNode);
    }

    public void removeChild(XmlElement iNode) {
        if (this.children == null) {
            return;
        }
        this.children.remove(iNode);
    }

    public void addAttribute(XmlAttribute iAttr) {
        if (iAttr == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap(1);
        }
        this.attributes.put(iAttr.getName(), iAttr);
    }

    public String getAttribute(String iName) {
        if (this.attributes == null) {
            return null;
        }
        XmlAttribute ret = this.attributes.get(iName);
        if (ret == null) {
            return null;
        }
        return ret.getValue();
    }

    public Set<String> getAttributeNames() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.keySet();
    }

    public Collection<XmlAttribute> getAttributes() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.values();
    }

    public List<XmlElement> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    public XmlElement getFirstChild() {
        if (this.children == null || this.children.size() == 0) {
            return null;
        }
        return this.children.get(0);
    }

    public String getContent() {
        return this.content == null ? null : this.content.toString();
    }

    public void appendContent(char[] chars, int start, int len) {
        if (this.content == null) {
            this.content = new StringBuffer(len);
        }
        this.content.append(chars, start, len);
    }

    public void setContent(String iContent) {
        this.content = iContent == null ? null : new StringBuffer(iContent);
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getTagName() {
        return this.tagName;
    }
}

