/*
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */
package org.ow2.orchestra.common.gwt.soapui.client;

/**
 * @author Loic Albertin
 * 
 * Exception class used to define an error in orchestra management server side.
 */
public class ServiceException extends Exception {
  private static final long serialVersionUID = 7193725009403111291L;
  /**
   * @author Mathieu Crassin
   *
   * Details about the orchestra error.
   */
  private String details = null;
  
  /**
   * @author Mathieu Crassin
   *
   * Default constructor (ask during compilation).
   */
  public ServiceException() {
    super("Default service exception");
  }  
  /**
   * @author Mathieu Crassin
   * @param mainInfo : main information about the exception.
   * @param details : details about the exception.
   *
   * Constructor to define an orchestra exception.
   */
  public ServiceException(final String mainInfo, final String details) {
    super(mainInfo);
    this.details = details;
  }

  /**
   * @author Mathieu Crassin
   *
   * Get method of details object.
   */
  public String getDetails() {
    return details;
  }
}
