/*
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.common.gwt.soapui.client.events;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;

/**
 * @author Loic Albertin
 */
public class CloseTabEvent extends GwtEvent<CloseTabEvent.CloseTabEventHandler>{
  public static interface CloseTabEventHandler extends EventHandler {
    public void onCloseTab(CloseTabEvent event);
  }

  private String key;

  public CloseTabEvent(String key) {
    this.key = key;
  }

  public static final Type<CloseTabEventHandler> TYPE = new Type<CloseTabEventHandler>();

  @Override
  public Type<CloseTabEventHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(CloseTabEventHandler closeTabEventHandler) {
    closeTabEventHandler.onCloseTab(this);
  }

  public String getKey() {
    return key;
  }
}
