/*
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.common.gwt.soapui.client.factories.impl;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.SimpleEventBus;
import org.ow2.orchestra.common.gwt.soapui.client.factories.ClientFactory;
import org.ow2.orchestra.common.gwt.soapui.client.factories.ws.interactions.RequestResponseClientFactory;
import org.ow2.orchestra.common.gwt.soapui.client.factories.ws.interactions.impl.DefaultRequestResponseClientFactory;
import org.ow2.orchestra.common.gwt.soapui.client.factories.wsdl.explorer.WsdlExplorerClientFactory;
import org.ow2.orchestra.common.gwt.soapui.client.factories.wsdl.explorer.impl.DefaultWsdlExplorerClientFactory;
import org.ow2.orchestra.common.gwt.soapui.client.presenters.DefaultSoapUIWidgetPresenter;
import org.ow2.orchestra.common.gwt.soapui.client.ui.SoapUIWidget;
import org.ow2.orchestra.common.gwt.soapui.client.ui.impl.DefaultSoapUIWidget;
import org.ow2.orchestra.common.gwt.soapui.client.ui.wsdl.explorer.WsdlExplorer;
import org.ow2.orchestra.common.gwt.soapui.client.ui.wsdl.explorer.impl.DefaultWsdlExplorer;

/**
 * @author Loic Albertin
 */
public class DefaultClientFactory implements ClientFactory {
  private final EventBus eventBus = new SimpleEventBus();

  private final SoapUIWidget soapUIWidget;

  private final WsdlExplorerClientFactory wsdlExplorerClientFactory;

  private final RequestResponseClientFactory requestResponseClientFactory;

  public DefaultClientFactory() {

    this.wsdlExplorerClientFactory = new DefaultWsdlExplorerClientFactory(eventBus);
    this.requestResponseClientFactory = new DefaultRequestResponseClientFactory(eventBus);

    soapUIWidget = new DefaultSoapUIWidget(wsdlExplorerClientFactory.getWsdlExplorer(),
            requestResponseClientFactory.getRequestResponsePanel());
    soapUIWidget.setPresenter(new DefaultSoapUIWidgetPresenter(eventBus));
  }

  public EventBus getEventBus() {
    return eventBus;
  }

  public SoapUIWidget getSoapUiWidget() {
    return soapUIWidget;
  }

  public WsdlExplorerClientFactory getWsdlExplorerClientFactory() {
    return wsdlExplorerClientFactory;
  }

  public RequestResponseClientFactory getRequestResponseClientFactory() {
    return requestResponseClientFactory;
  }
}
