/*
 * Copyright (C) 2012 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.common.gwt.soapui.client.model;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.Collection;
import java.util.HashSet;

/**
 * @author Loic Albertin
 */
public class WsdlInterface implements IsSerializable {

  private WsdlProject wsdlProject;
  private String interfaceName;
  private Collection<WsdlOperation> operations = new HashSet<WsdlOperation>();

  /**
   * Empty constructor for Serialization
   */
  public WsdlInterface() {
    this(null, null);
  }

  public WsdlInterface(WsdlProject wsdlProject, String interfaceName) {
    this(wsdlProject, interfaceName, null);
  }

  public WsdlInterface(WsdlProject wsdlProject, String interfaceName, String operationName) {
    this.wsdlProject = wsdlProject;
    this.interfaceName = interfaceName;
    this.addOperation(operationName);
  }

  public WsdlProject getWsdlProject() {
    return wsdlProject;
  }

  /**
   * setter for Serialization
   */
  public void setWsdlProject(WsdlProject wsdlProject) {
    this.wsdlProject = wsdlProject;
  }

  public String getInterfaceName() {
    return interfaceName;
  }

  /**
   * setter for Serialization
   */
  public void setInterfaceName(String interfaceName) {
    this.interfaceName = interfaceName;
  }

  public Collection<WsdlOperation> getOperations() {
    return operations;
  }

  /**
   * setter for Serialization
   */
  public void setOperations(Collection<WsdlOperation> operations) {
    this.operations = operations;
  }

  public WsdlOperation addOperation(final String operationName) {
    if (operationName == null) {
      return null;
    }
    WsdlOperation wsdlOperation = new WsdlOperation(this, operationName);
    this.operations.add(wsdlOperation);
    return wsdlOperation;
  }
}
