/*
 * Copyright (C) 2012 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.common.gwt.soapui.client.model;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * @author Loic Albertin
 */
public class WsdlOperation implements IsSerializable {

  private WsdlInterface wsdlInterface;
  private String operationName;

  /**
   * Empty constructor for Serialization
   */
  public WsdlOperation() {
    this(null, null);
  }

  public WsdlOperation(WsdlInterface wsdlInterface, String operationName) {
    this.operationName = operationName;
    this.wsdlInterface = wsdlInterface;
  }

  public WsdlInterface getWsdlInterface() {
    return wsdlInterface;
  }

  /**
   * setter for Serialization
   */
  public void setWsdlInterface(WsdlInterface wsdlInterface) {
    this.wsdlInterface = wsdlInterface;
  }

  public String getOperationName() {
    return operationName;
  }

  /**
     * setter for Serialization
     */
  public void setOperationName(String operationName) {
    this.operationName = operationName;
  }
}
