/*
 * Copyright (C) 2012 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.common.gwt.soapui.client.model;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.Collection;
import java.util.HashSet;

/**
 * @author Loic Albertin
 */
public class WsdlProject implements IsSerializable {

  private String wsdlUrl;
  private Collection<WsdlInterface> wsdlInterfaces = new HashSet<WsdlInterface>();

  /**
   * Empty constructor for Serialization
   */
  public WsdlProject() {
    this(null);
  }

  public WsdlProject(String wsdlUrl) {
    this(wsdlUrl, null);
  }

  public WsdlProject(String wsdlUrl, String interfaceName) {
    this.wsdlUrl = wsdlUrl;
    this.addInterfaceModel(interfaceName);
  }

  public String getWsdlUrl() {
    return wsdlUrl;
  }

  /**
   * setter for Serialization
   */
  public void setWsdlUrl(String wsdlUrl) {
    this.wsdlUrl = wsdlUrl;
  }

  public Collection<WsdlInterface> getWsdlInterfaces() {
    return wsdlInterfaces;
  }

  /**
   * setter for Serialization
   */
  public void setWsdlInterfaces(Collection<WsdlInterface> wsdlInterfaces) {
    this.wsdlInterfaces = wsdlInterfaces;
  }

  public WsdlInterface addInterfaceModel(final String interfaceName) {
    if (interfaceName == null) {
      return null;
    }
    WsdlInterface wsdlInterface = new WsdlInterface(this, interfaceName);
    this.wsdlInterfaces.add(wsdlInterface);
    return wsdlInterface;
  }
}
