/*
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.common.gwt.soapui.client.presenters;

import com.google.gwt.event.shared.EventBus;
import org.ow2.orchestra.common.gwt.soapui.client.events.ExploreWsdlEvent;
import org.ow2.orchestra.common.gwt.soapui.client.ui.SoapUIWidget;

/**
 * @author Loic Albertin
 */
public class DefaultSoapUIWidgetPresenter implements SoapUIWidget.Presenter {

  private EventBus eventBus;

  public DefaultSoapUIWidgetPresenter(EventBus eventBus) {
    this.eventBus = eventBus;
  }

  public void exploreWsdl(String wsdlUrl) {
    eventBus.fireEvent(new ExploreWsdlEvent(wsdlUrl));
  }
}
