/*
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.common.gwt.soapui.client.presenters.ws.interactions;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.ow2.orchestra.common.gwt.soapui.client.SoapUIServices;
import org.ow2.orchestra.common.gwt.soapui.client.SoapUIServicesAsync;
import org.ow2.orchestra.common.gwt.soapui.client.events.OpenOperationEvent;
import org.ow2.orchestra.common.gwt.soapui.client.model.WsdlOperation;
import org.ow2.orchestra.common.gwt.soapui.client.ui.ws.interactions.RequestResponsePanel;

/**
 * @author Loic Albertin
 */
public class RequestResponsePresenter implements RequestResponsePanel.Presenter {

  private RequestResponsePanel requestResponsePanel;

  private SoapUIServicesAsync soapUIServices = GWT.create(SoapUIServices.class);

  public RequestResponsePresenter(EventBus eventBus, RequestResponsePanel requestResponsePanel) {
    this.requestResponsePanel = requestResponsePanel;
    eventBus.addHandler(OpenOperationEvent.TYPE, new OpenOperationEvent.OpenOperationEventHandler() {
      public void onOpenOperation(OpenOperationEvent event) {
        RequestResponsePresenter.this.handleOpenOperation(event.getWsdlOperation());
      }
    });
  }

  public void handleOpenOperation(final WsdlOperation wsdlOperation) {
    requestResponsePanel.addRequestResponseTab(wsdlOperation);
  }

  public void generateRequest(final String key, final WsdlOperation wsdlOperation) {
    soapUIServices.generateRequest(wsdlOperation.getWsdlInterface().getWsdlProject().getWsdlUrl(),
        wsdlOperation.getWsdlInterface().getInterfaceName(), wsdlOperation.getOperationName(),
        new AsyncCallback<String>() {
          public void onFailure(Throwable throwable) {
            GWT.log("Unable to access soapui!\n" + throwable.getMessage());
          }

          public void onSuccess(String request) {
            requestResponsePanel.displayRequest(key, wsdlOperation, request);

          }
        });
  }

  public void sendRequest(final String key, final WsdlOperation wsdlOperation, final String request) {
    soapUIServices.sendRequest(wsdlOperation.getWsdlInterface().getWsdlProject().getWsdlUrl(),
            wsdlOperation.getWsdlInterface().getInterfaceName(), wsdlOperation.getOperationName(), request, new AsyncCallback<String>() {
      public void onFailure(Throwable throwable) {
        GWT.log("Unable to access soapui!\n" + throwable.getMessage());
      }

      public void onSuccess(String result) {
        RequestResponsePresenter.this.requestResponsePanel.displayResult(key, wsdlOperation, result);
      }
    });
  }
}
