/*
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.common.gwt.soapui.client.ui.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.SimpleLayoutPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.ow2.orchestra.common.gwt.soapui.client.ui.SoapUIWidget;
import org.ow2.orchestra.common.gwt.soapui.client.ui.ws.interactions.RequestResponsePanel;
import org.ow2.orchestra.common.gwt.soapui.client.ui.wsdl.explorer.WsdlExplorer;

/**
 * @author Loic Albertin
 */
public class DefaultSoapUIWidget extends Composite implements SoapUIWidget {

  interface WidgetUIBinder extends UiBinder<Widget, DefaultSoapUIWidget> {
  }

  private SoapUIWidget.Presenter presenter;

  private static WidgetUIBinder uiBinder = GWT.create(WidgetUIBinder.class);

  @UiField
  Button analyzeButton;
  @UiField
  DockLayoutPanel dockLayoutPanel;

  @UiField
  TextBox textBox;

  @UiField
  SimpleLayoutPanel wsdlExplorerContainer;
  @UiField
  SimpleLayoutPanel requestResponsePanelContainer;

  private WsdlExplorer wsdlExplorer;


  public DefaultSoapUIWidget(final WsdlExplorer wsdlExplorer, final RequestResponsePanel requestResponsePanel) {
    initWidget(uiBinder.createAndBindUi(this));
    this.wsdlExplorer = wsdlExplorer;
    wsdlExplorerContainer.add(wsdlExplorer);
    requestResponsePanelContainer.add(requestResponsePanel);
  }

  @UiHandler("analyzeButton")
  public void handleClick(final ClickEvent event) {
    this.wsdlExplorer.getPresenter().clear();
    presenter.exploreWsdl(textBox.getText());
  }

  public void setPresenter(final Presenter presenter) {
    this.presenter = presenter;
  }
}
