/*
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.common.gwt.soapui.client.ui.ws.interactions.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.SimpleEventBus;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.ow2.orchestra.common.gwt.soapui.client.events.CloseTabEvent;
import org.ow2.orchestra.common.gwt.soapui.client.model.WsdlOperation;
import org.ow2.orchestra.common.gwt.soapui.client.ui.ws.interactions.RequestResponsePanel;

/**
 * @author Loic Albertin
 */
public class DefaultRequestResponsePanel extends Composite implements RequestResponsePanel {
  interface RequestResponsePanelUiBinder extends UiBinder<Widget, DefaultRequestResponsePanel> {
  }

  private static RequestResponsePanelUiBinder ourUiBinder = GWT.create(RequestResponsePanelUiBinder.class);

  private Presenter presenter;

  private EventBus eventBus = new SimpleEventBus();

  private long nextKey = 0;

  private class Tab {
    private ClosableTabHeader header;
    private RequestResponseArea area;

    private Tab(ClosableTabHeader header, RequestResponseArea area) {
      this.header = header;
      this.area = area;
    }

    public ClosableTabHeader getHeader() {
      return header;
    }

    public RequestResponseArea getArea() {
      return area;
    }
  }

  @UiField
  ScrollableTabLayoutPanelContainer tabPanel;

  private Map<String, Tab> keysToTab = new HashMap<String, Tab>();

  public DefaultRequestResponsePanel() {
    initWidget(ourUiBinder.createAndBindUi(this));

    eventBus.addHandler(CloseTabEvent.TYPE, new CloseTabEvent.CloseTabEventHandler() {
      public void onCloseTab(CloseTabEvent event) {
        tabPanel.getScrollableTabLayoutPanel().remove(keysToTab.get(event.getKey()).getArea());
        keysToTab.remove(event.getKey());
      }
    });
  }

  public void setPresenter(Presenter presenter) {
    this.presenter = presenter;
  }

  public void addRequestResponseTab(final WsdlOperation wsdlOperation) {
    final String defaultName = wsdlOperation.getWsdlInterface().getInterfaceName() + "." +
        wsdlOperation.getOperationName();
    String key = null;
    for (Map.Entry<String, Tab> stringTabEntry : keysToTab.entrySet()) {
      if (defaultName.equals(stringTabEntry.getValue().getHeader().label.getText())) {
        key = stringTabEntry.getKey();
        break;
      }
    }
    if (key == null) {
      key =  this.generateKey();
      this.presenter.generateRequest(key, wsdlOperation);
    } else {
      tabPanel.getScrollableTabLayoutPanel().selectTab(keysToTab.get(key).getArea());
    }
  }

  public void displayRequest(final String key, final WsdlOperation wsdlOperation, final String request) {
    RequestResponseArea widget = new RequestResponseArea(key, wsdlOperation, request, presenter);
    ClosableTabHeader header = new ClosableTabHeader(wsdlOperation.getWsdlInterface().getInterfaceName() + "." +
        wsdlOperation.getOperationName(),
        eventBus, key, true, true);
    keysToTab.put(key, new Tab(header, widget));
    tabPanel.getScrollableTabLayoutPanel().add(widget, header);
    tabPanel.getScrollableTabLayoutPanel().selectTab(widget);
  }

  public void displayResult(final String key, final WsdlOperation wsdlOperation, final String result) {
    Widget widget = this.tabPanel.getScrollableTabLayoutPanel().getWidget(
        this.tabPanel.getScrollableTabLayoutPanel().getWidgetIndex(this.keysToTab.get(key).getArea()));
    if (widget instanceof RequestResponseArea) {
      ((RequestResponseArea) widget).displayResult(result);
    }
  }

  private String generateKey() {
    return "key" + (++nextKey);
  }
}