/*
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.common.gwt.soapui.client.ui.ws.interactions.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import org.ow2.orchestra.common.gwt.soapui.client.model.WsdlOperation;
import org.ow2.orchestra.common.gwt.soapui.client.ui.ws.interactions.RequestResponsePanel;

/**
 * @author Loic Albertin
 */
public class RequestResponseArea extends Composite{
  interface RequestResponseAreaUiBinder extends UiBinder<Widget, RequestResponseArea> {
  }

  private static RequestResponseAreaUiBinder ourUiBinder = GWT.create(RequestResponseAreaUiBinder.class);
  @UiField
  Button sendButton;
  @UiField
  TextArea requestArea;
  @UiField
  TextArea responseArea;
  @UiField
  SplitLayoutPanel splitPanel;

  @UiField
  Label details;

  private final RequestResponsePanel.Presenter presenter;
  private String key;
  private final WsdlOperation wsdlOperation;
  public static final double REDUCED_TEXT_AREA_SIZE = 70.0;

  public RequestResponseArea(final String key, final WsdlOperation wsdlOperation,
                             final String request, final RequestResponsePanel.Presenter presenter) {
    this.initWidget(ourUiBinder.createAndBindUi(this));
    requestArea.setText(request);
    this.presenter = presenter;
    this.wsdlOperation = wsdlOperation;
    this.key = key;
    details.setText("Interface: " + wsdlOperation.getWsdlInterface().getInterfaceName() + ", " +
        "Operation: " + wsdlOperation.getOperationName());
  }

  public void displayResult(final String result) {
    responseArea.setText(result);
    splitPanel.setWidgetSize(requestArea, REDUCED_TEXT_AREA_SIZE);
    splitPanel.forceLayout();
  }

  @UiHandler("sendButton")
  public void handleClick(ClickEvent event) {
    if (requestArea.getText() != null && requestArea.getText() != null) {
      presenter.sendRequest(key, this.wsdlOperation, requestArea.getText());
    }
  }

  public void setKey(String key) {
    this.key = key;
  }
}
