/*
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.common.gwt.soapui.client.ui.wsdl.explorer;

import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.TreeItem;
import org.ow2.orchestra.common.gwt.soapui.client.model.WsdlProject;

/**
 * @author Loic Albertin
 */
public interface WsdlExplorer extends IsWidget {


  public interface WsdlPresenter extends OpenHandler<TreeItem>, SelectionHandler<TreeItem> {
    void exploreWsdl(final String wsdlUrl);
    void exploreModel(final WsdlProject model);

    void clear();

  }


  public void setPresenter(WsdlPresenter presenter);

  public WsdlPresenter getPresenter();

  public void clear();

  public TreeItem addItem(final String item);

}
