/*
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.common.gwt.soapui.client.ui.wsdl.explorer.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import org.ow2.orchestra.common.gwt.soapui.client.ui.wsdl.explorer.WsdlExplorer;

/**
 * @author Loic Albertin
 */
public class DefaultWsdlExplorer extends Composite implements WsdlExplorer {

  interface WidgetUIBinder extends UiBinder<Widget, DefaultWsdlExplorer> {
  }

  private WsdlPresenter presenter;

  private static WidgetUIBinder uiBinder = GWT.create(WidgetUIBinder.class);

  @UiField
  Tree tree;

  public DefaultWsdlExplorer() {
    initWidget(uiBinder.createAndBindUi(this));
  }

  public void setPresenter(WsdlPresenter presenter) {
    this.presenter = presenter;
    tree.addOpenHandler(presenter);
    tree.addSelectionHandler(presenter);
  }

  public WsdlPresenter getPresenter() {
    return presenter;
  }

  public void clear() {
    tree.clear();
  }

  public TreeItem addItem(final String item) {
    return tree.addItem(item);
  }

}
