/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.common.gwt.soapui.client.presenters.ws.interactions;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.ow2.orchestra.common.gwt.soapui.client.SoapUIServices;
import org.ow2.orchestra.common.gwt.soapui.client.SoapUIServicesAsync;
import org.ow2.orchestra.common.gwt.soapui.client.events.OpenOperationEvent;
import org.ow2.orchestra.common.gwt.soapui.client.model.WsdlOperation;
import org.ow2.orchestra.common.gwt.soapui.client.ui.ws.interactions.RequestResponsePanel;

public class RequestResponsePresenter
implements RequestResponsePanel.Presenter {
    private RequestResponsePanel requestResponsePanel;
    private SoapUIServicesAsync soapUIServices = (SoapUIServicesAsync)GWT.create(SoapUIServices.class);

    public RequestResponsePresenter(EventBus eventBus, RequestResponsePanel requestResponsePanel) {
        this.requestResponsePanel = requestResponsePanel;
        eventBus.addHandler(OpenOperationEvent.TYPE, (EventHandler)new OpenOperationEvent.OpenOperationEventHandler(){

            public void onOpenOperation(OpenOperationEvent event) {
                RequestResponsePresenter.this.handleOpenOperation(event.getWsdlOperation());
            }
        });
    }

    public void handleOpenOperation(WsdlOperation wsdlOperation) {
        this.requestResponsePanel.addRequestResponseTab(wsdlOperation);
    }

    public void generateRequest(final String key, final WsdlOperation wsdlOperation) {
        this.soapUIServices.generateRequest(wsdlOperation.getWsdlInterface().getWsdlProject().getWsdlUrl(), wsdlOperation.getWsdlInterface().getInterfaceName(), wsdlOperation.getOperationName(), new AsyncCallback<String>(){

            public void onFailure(Throwable throwable) {
                GWT.log((String)("Unable to access soapui!\n" + throwable.getMessage()));
            }

            public void onSuccess(String request) {
                RequestResponsePresenter.this.requestResponsePanel.displayRequest(key, wsdlOperation, request);
            }
        });
    }

    public void sendRequest(final String key, final WsdlOperation wsdlOperation, String request) {
        this.soapUIServices.sendRequest(wsdlOperation.getWsdlInterface().getWsdlProject().getWsdlUrl(), wsdlOperation.getWsdlInterface().getInterfaceName(), wsdlOperation.getOperationName(), request, new AsyncCallback<String>(){

            public void onFailure(Throwable throwable) {
                GWT.log((String)("Unable to access soapui!\n" + throwable.getMessage()));
            }

            public void onSuccess(String result) {
                RequestResponsePresenter.this.requestResponsePanel.displayResult(key, wsdlOperation, result);
            }
        });
    }
}

