/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.common.gwt.soapui.client.presenters.wsdl.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.TreeItem;
import java.util.List;
import org.ow2.orchestra.common.gwt.soapui.client.SoapUIServices;
import org.ow2.orchestra.common.gwt.soapui.client.SoapUIServicesAsync;
import org.ow2.orchestra.common.gwt.soapui.client.events.ExploreWsdlEvent;
import org.ow2.orchestra.common.gwt.soapui.client.events.OpenOperationEvent;
import org.ow2.orchestra.common.gwt.soapui.client.model.WsdlInterface;
import org.ow2.orchestra.common.gwt.soapui.client.model.WsdlOperation;
import org.ow2.orchestra.common.gwt.soapui.client.model.WsdlProject;
import org.ow2.orchestra.common.gwt.soapui.client.ui.wsdl.explorer.WsdlExplorer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlPresenterImpl
implements WsdlExplorer.WsdlPresenter {
    private static final String OPERATION_PREFIX = "operation: ";
    private static final String INTERFACE_PREFIX = "interface: ";
    private WsdlExplorer view;
    private EventBus eventBus;
    private SoapUIServicesAsync soapUIServices = (SoapUIServicesAsync)GWT.create(SoapUIServices.class);

    public WsdlPresenterImpl(WsdlExplorer view, EventBus bus) {
        this.view = view;
        this.eventBus = bus;
        bus.addHandler(ExploreWsdlEvent.TYPE, (EventHandler)new ExploreWsdlEvent.ExploreWsdlEventHandler(){

            public void onExploreWsdl(ExploreWsdlEvent event) {
                WsdlPresenterImpl.this.exploreWsdl(event.getWsdlUrl());
            }
        });
    }

    public void onOpen(OpenEvent<TreeItem> treeItemOpenEvent) {
        final TreeItem targetItem = (TreeItem)treeItemOpenEvent.getTarget();
        if (targetItem.getUserObject() != null && targetItem.getUserObject() instanceof WsdlInterface) {
            if (targetItem.getChildCount() == 1 && "".equals(targetItem.getChild(0).getText())) {
                targetItem.setState(false, false);
                targetItem.getChild(0).remove();
                final WsdlInterface wsdlInterface = (WsdlInterface)targetItem.getUserObject();
                this.soapUIServices.getOperations(wsdlInterface.getWsdlProject().getWsdlUrl(), wsdlInterface.getInterfaceName(), new AsyncCallback<List<String>>(){

                    public void onFailure(Throwable caught) {
                        GWT.log((String)("Unable to access soapui!\n" + caught.getMessage()));
                    }

                    public void onSuccess(List<String> result) {
                        for (String s : result) {
                            WsdlOperation wsdlOperation = wsdlInterface.addOperation(s);
                            TreeItem item = targetItem.addItem(WsdlPresenterImpl.OPERATION_PREFIX + s);
                            item.setUserObject((Object)wsdlOperation);
                        }
                        targetItem.setState(true, false);
                    }
                });
            } else {
                targetItem.setState(true, false);
            }
        }
    }

    @Override
    public void clear() {
        this.view.clear();
    }

    @Override
    public void exploreWsdl(String wsdlUrl) {
        final WsdlProject model = new WsdlProject(wsdlUrl);
        this.soapUIServices.getInterfaces(wsdlUrl, new AsyncCallback<List<String>>(){

            public void onFailure(Throwable caught) {
                GWT.log((String)("Unable to access soapui!\n" + caught.getMessage()));
            }

            public void onSuccess(List<String> result) {
                for (String s : result) {
                    WsdlInterface wsdlInterface = model.addInterfaceModel(s);
                    TreeItem item = WsdlPresenterImpl.this.view.addItem(WsdlPresenterImpl.INTERFACE_PREFIX + s);
                    item.setUserObject((Object)wsdlInterface);
                    item.addItem("");
                }
            }
        });
    }

    @Override
    public void exploreModel(WsdlProject model) {
        if (model.getWsdlInterfaces().size() == 0) {
            this.exploreWsdl(model.getWsdlUrl());
        } else {
            for (WsdlInterface wsdlInterface : model.getWsdlInterfaces()) {
                TreeItem interfaceTreeItem = this.view.addItem(INTERFACE_PREFIX + wsdlInterface.getInterfaceName());
                interfaceTreeItem.setUserObject((Object)wsdlInterface);
                if (wsdlInterface.getOperations().size() > 0) {
                    for (WsdlOperation wsdlOperation : wsdlInterface.getOperations()) {
                        TreeItem operationTreeItem = interfaceTreeItem.addItem(OPERATION_PREFIX + wsdlOperation.getOperationName());
                        operationTreeItem.setUserObject((Object)wsdlOperation);
                    }
                    continue;
                }
                interfaceTreeItem.addItem("");
            }
        }
    }

    public void onSelection(SelectionEvent<TreeItem> treeItemSelectionEvent) {
        TreeItem targetItem = (TreeItem)treeItemSelectionEvent.getSelectedItem();
        if (targetItem.getUserObject() instanceof WsdlOperation) {
            WsdlOperation wsdlOperation = (WsdlOperation)targetItem.getUserObject();
            this.eventBus.fireEvent((GwtEvent)new OpenOperationEvent(wsdlOperation));
        } else if (targetItem.getUserObject() instanceof WsdlInterface) {
            OpenEvent.fire((HasOpenHandlers)((HasOpenHandlers)treeItemSelectionEvent.getSource()), (Object)targetItem);
        }
    }
}

