/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.common.gwt.soapui.client.ui.ws.interactions.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.SimpleEventBus;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.ow2.orchestra.common.gwt.soapui.client.events.CloseTabEvent;
import org.ow2.orchestra.common.gwt.soapui.client.events.RenameTabEvent;

public class ClosableTabHeader
extends Composite {
    private static ClosableTabHeaderUiBinder ourUiBinder = (ClosableTabHeaderUiBinder)GWT.create(ClosableTabHeaderUiBinder.class);
    private static final Resources RESOURCES = (Resources)GWT.create(Resources.class);
    @UiField
    Label label;
    @UiField
    Image button;
    @UiField
    TextBox inputText;
    private EventBus eventBus;
    private String key;
    private boolean allowRename;

    @UiConstructor
    public ClosableTabHeader(String headerLabel) {
        this(headerLabel, (EventBus)new SimpleEventBus(), headerLabel);
    }

    @UiConstructor
    public ClosableTabHeader(String headerLabel, boolean isClosable) {
        this(headerLabel, isClosable, false);
    }

    @UiConstructor
    public ClosableTabHeader(String headerLabel, boolean isClosable, boolean allowRename) {
        this(headerLabel, (EventBus)new SimpleEventBus(), headerLabel, isClosable, allowRename);
    }

    public ClosableTabHeader(String headerLabel, EventBus eventBus, String key) {
        this(headerLabel, eventBus, key, false);
    }

    public ClosableTabHeader(String headerLabel, EventBus eventBus, String key, boolean isClosable) {
        this(headerLabel, eventBus, key, isClosable, false);
    }

    public ClosableTabHeader(String headerLabel, EventBus eventBus, String key, boolean isClosable, boolean allowRename) {
        this.initWidget((Widget)ourUiBinder.createAndBindUi((Object)this));
        this.label.setText(headerLabel);
        this.label.setTitle(headerLabel);
        this.eventBus = eventBus;
        this.key = key;
        this.button.setVisible(isClosable);
        this.allowRename = allowRename;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    @UiHandler(value={"button"})
    public void handleClickOnCloseButton(ClickEvent event) {
        this.eventBus.fireEvent((GwtEvent)new CloseTabEvent(this.key));
    }

    @UiHandler(value={"button"})
    public void handleMouseOverOnCloseButton(MouseOverEvent event) {
        this.button.setResource(RESOURCES.closeOverImage());
    }

    @UiHandler(value={"button"})
    public void handleMouseOutOnCloseButton(MouseOutEvent event) {
        this.button.setResource(RESOURCES.closeImage());
    }

    @UiHandler(value={"label"})
    public void handleDoubleClickOnLabel(DoubleClickEvent event) {
        if (this.allowRename) {
            this.label.setVisible(false);
            this.inputText.setText(this.label.getText());
            this.inputText.setVisible(true);
        }
    }

    @UiHandler(value={"inputText"})
    public void handleChange(ChangeEvent event) {
        this.updateLabelAccordingTextInput();
    }

    @UiHandler(value={"inputText"})
    public void handleBlur(BlurEvent event) {
        this.updateLabelAccordingTextInput();
    }

    private void updateLabelAccordingTextInput() {
        String oldValue = this.label.getText();
        String newValue = this.inputText.getText();
        this.inputText.setVisible(false);
        this.label.setText(newValue);
        this.label.setVisible(true);
        this.eventBus.fireEvent((GwtEvent)new RenameTabEvent(this.key, oldValue, newValue));
    }

    public static interface Resources
    extends ClientBundle {
        @ClientBundle.Source(value={"close.png"})
        public ImageResource closeImage();

        @ClientBundle.Source(value={"closeOver.png"})
        public ImageResource closeOverImage();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ClosableTabHeaderUiBinder
    extends UiBinder<Widget, ClosableTabHeader> {
    }
}

