/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.common.gwt.soapui.server;

import com.eviware.soapui.DefaultSoapUICore;
import com.eviware.soapui.SoapUI;
import com.eviware.soapui.SoapUICore;
import com.eviware.soapui.impl.WsdlInterfaceFactory;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.WsdlSubmit;
import com.eviware.soapui.impl.wsdl.WsdlSubmitContext;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.settings.ProxySettings;
import com.eviware.soapui.support.SoapUIException;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.ow2.orchestra.common.gwt.soapui.client.ServiceException;
import org.ow2.orchestra.common.gwt.soapui.client.SoapUIServices;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapUIServlet
extends RemoteServiceServlet
implements SoapUIServices {
    private static final long serialVersionUID = -80411514041641896L;
    private static final String TMP_DIR = System.getProperty("java.io.tmpdir", ".");
    protected static final Logger LOG = Logger.getLogger(SoapUIServlet.class.getName());

    public static String generateNonProxyHostsInSoapUIFormat(String nonProxyHosts) {
        String[] patterns = nonProxyHosts.split("\\|");
        StringBuilder sb = new StringBuilder();
        for (String pattern : patterns) {
            pattern = pattern.replace("\"", "");
            pattern = pattern.replace("'", "");
            boolean endsByWildcard = false;
            if (pattern.startsWith("*")) {
                sb.append(".*");
                pattern = pattern.substring(1);
            }
            if (pattern.endsWith("*")) {
                endsByWildcard = true;
                pattern = pattern.substring(0, pattern.length() - 1);
            }
            sb.append(Pattern.quote(pattern));
            if (endsByWildcard) {
                sb.append(".*");
            }
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    public void init() throws ServletException {
        super.init();
        try {
            Misc.fastDynamicLog((Logger)LOG, (Level)Level.INFO, (String)"Initializing SoapUI.", (Object[])new Object[0]);
            File soapUIHome = new File(TMP_DIR + File.separator + "gwt-soapui");
            File soapUIConfigFile = new File(soapUIHome, "soapui-settings.xml");
            if (!soapUIHome.exists()) {
                if (!soapUIHome.mkdirs()) {
                    Misc.fastDynamicLog((Logger)LOG, (Level)Level.WARNING, (String)"Failed to create path '%s'. SoapUI configuration will fall back to the default behavior.", (Object[])new Object[]{soapUIHome.getAbsolutePath()});
                } else if (!soapUIConfigFile.exists()) {
                    if (!soapUIConfigFile.createNewFile()) {
                        Misc.fastDynamicLog((Logger)LOG, (Level)Level.WARNING, (String)"Failed to create SoapUI configuration file '%s'.SoapUI configuration will fall back to the default behavior.", (Object[])new Object[]{soapUIConfigFile.getAbsolutePath()});
                    } else {
                        Misc.fastDynamicLog((Logger)LOG, (Level)Level.FINE, (String)"Custom empty SoapUI configuration file created at '%s'.", (Object[])new Object[]{soapUIConfigFile.getAbsolutePath()});
                    }
                }
            }
            SoapUI.setSoapUICore((SoapUICore)new DefaultSoapUICore(null, soapUIConfigFile.getAbsolutePath()), (boolean)true);
            Misc.fastDynamicLog((Logger)LOG, (Level)Level.INFO, (String)"Initialization done.", (Object[])new Object[0]);
        }
        catch (IOException e) {
            throw new ServletException("SoapUI configuration error", (Throwable)e);
        }
    }

    public void destroy() {
        SoapUI.shutdown();
        super.destroy();
    }

    public synchronized WsdlInterface[] getInterfaces(String wsdlUrl, boolean createRequests) throws ServiceException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(XmlObject.class.getClassLoader());
        try {
            if (System.getProperty("http.proxyHost") != null && System.getProperty("http.nonProxyHosts") != null && SoapUI.getSettings().getString(ProxySettings.EXCLUDES, null) == null) {
                Misc.fastDynamicLog((Logger)LOG, (Level)Level.FINE, (String)"Setting system property 'nonProxyHosts' to SoapUI config.", (Object[])new Object[0]);
                String nonProxyHosts = System.getProperty("http.nonProxyHosts");
                SoapUI.getSettings().setString(ProxySettings.EXCLUDES, SoapUIServlet.generateNonProxyHostsInSoapUIFormat(nonProxyHosts));
            }
            WsdlProject project = new WsdlProject();
            Misc.fastDynamicLog((Logger)LOG, (Level)Level.FINE, (String)"Retrieving interfaces for url '%s.'", (Object[])new Object[]{wsdlUrl});
            WsdlInterface[] wsdlInterfaceArray = WsdlInterfaceFactory.importWsdl((WsdlProject)project, (String)wsdlUrl, (boolean)createRequests);
            return wsdlInterfaceArray;
        }
        catch (XmlException e) {
            Misc.fastDynamicLog((Logger)LOG, (Level)Level.FINE, (String)"Unable to get wsdl interfaces:\n%s", (Object[])new Object[]{Misc.getStackTraceFrom((Throwable)e)});
            throw new ServiceException("Unable to get wsdl interfaces", e.getMessage());
        }
        catch (IOException e) {
            Misc.fastDynamicLog((Logger)LOG, (Level)Level.FINE, (String)"Unable to get wsdl interfaces:\n%s", (Object[])new Object[]{Misc.getStackTraceFrom((Throwable)e)});
            throw new ServiceException("Unable to get wsdl interfaces", e.getMessage());
        }
        catch (SoapUIException e) {
            Misc.fastDynamicLog((Logger)LOG, (Level)Level.FINE, (String)"Unable to get wsdl interfaces:\n%s", (Object[])new Object[]{Misc.getStackTraceFrom((Throwable)e)});
            throw new ServiceException("Unable to get wsdl interfaces", e.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public List<String> getInterfaces(String wsdlUrl) throws ServiceException {
        WsdlInterface[] ifces;
        ArrayList<String> interfaces = new ArrayList<String>();
        for (WsdlInterface ifce : ifces = this.getInterfaces(wsdlUrl, false)) {
            interfaces.add(ifce.getName());
        }
        return interfaces;
    }

    @Override
    public List<String> getOperations(String wsdlUrl, String interfaceName) throws ServiceException {
        WsdlInterface[] ifces;
        ArrayList<String> operations = new ArrayList<String>();
        for (WsdlInterface ifce : ifces = this.getInterfaces(wsdlUrl, false)) {
            if (!ifce.getName().equals(interfaceName)) continue;
            for (Operation operation : ifce.getOperationList()) {
                operations.add(operation.getName());
            }
            break;
        }
        return operations;
    }

    @Override
    public String generateRequest(String wsdlUrl, String interfaceName, String operationName) throws ServiceException {
        WsdlInterface[] ifces;
        String request = "";
        for (WsdlInterface ifce : ifces = this.getInterfaces(wsdlUrl, false)) {
            if (!ifce.getName().equals(interfaceName)) continue;
            WsdlOperation operation = ifce.getOperationByName(operationName);
            request = operation.createRequest(true);
            break;
        }
        return request;
    }

    @Override
    public String sendRequest(String wsdlUrl, String interfaceName, String operationName, String request) throws ServiceException {
        String textResponse = "";
        try {
            WsdlInterface[] ifces;
            for (WsdlInterface ifce : ifces = this.getInterfaces(wsdlUrl, true)) {
                if (!ifce.getName().equals(interfaceName)) continue;
                WsdlOperation operation = ifce.getOperationByName(operationName);
                WsdlRequest wsdlRequest = operation.addNewRequest(interfaceName + "." + operationName);
                wsdlRequest.setRequestContent(request);
                WsdlSubmitContext wsdlSubmitContext = new WsdlSubmitContext((ModelItem)wsdlRequest);
                WsdlSubmit submit = wsdlRequest.submit((SubmitContext)wsdlSubmitContext, false);
                Response response = submit.getResponse();
                textResponse = response.getContentAsString();
                break;
            }
        }
        catch (Request.SubmitException e) {
            Misc.fastDynamicLog((Logger)LOG, (Level)Level.FINE, (String)"Unable to send request for operation:\n%s", (Object[])new Object[]{Misc.getStackTraceFrom((Throwable)e)});
            throw new ServiceException("Unable to send request for operation '" + interfaceName + "." + operationName + "'", e.getMessage());
        }
        return textResponse;
    }
}

