/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.common.perf;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.orchestra.common.perf.PerfException;
import org.ow2.orchestra.common.perf.PerfTestCase;
import org.ow2.orchestra.common.perf.PerfTestCaseThread;
import org.ow2.orchestra.common.perf.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StressPerfTest {
    private Map<String, String> aliasesMap;
    private Map<String, String[]> globalAliasesMap;
    private String[] initialArgs;
    private long initialStartTime;
    private long startTime;
    private long endTime;
    private long lastPrintTime;
    private long finished = 0L;
    private long launched = 0L;
    private long measuredInstances = 0L;
    private Map<String, Long> executionTimes = new HashMap<String, Long>();
    private Map<String, Long> bestTimes = new HashMap<String, Long>();
    private Map<String, Long> worthTimes = new HashMap<String, Long>();
    private Map<String, Long> processSuccesses = new HashMap<String, Long>();
    private long expectedEndTime;
    private boolean launchPeriod = true;
    private boolean testFinished = false;
    private int successNb;
    private int errorNb;
    private boolean initialLaunchCompleted = false;
    private static final String ALGO_TYPE = "type";
    private static final String ALGO_NB = "nb";
    private List<PerfTestCase> testsToRun;
    private int threadNb = 1;
    private boolean printFinished = false;
    private boolean printLaunched = false;
    private long timeBetweenVerifications = 10000L;
    private long timeBetweenPrints = 60000L;
    private long loadTime = 60000L;
    private long warmupTime = 30000L;
    private long thinkTime = 1000L;
    private String algo = "type";

    public StressPerfTest(String[] args, Map<String, String> aliasesMap, Map<String, String[]> globalAliasesMap) throws PerfException {
        this.aliasesMap = aliasesMap;
        if (this.aliasesMap == null) {
            throw new PerfException("AliasesMap cannot be null!");
        }
        this.globalAliasesMap = globalAliasesMap;
        this.initialArgs = args;
        if (this.initialArgs == null) {
            throw new PerfException("args cannot be null!");
        }
        this.parseArgs();
    }

    public void deployTests() throws PerfException {
        for (PerfTestCase perfTestCase : this.testsToRun) {
            perfTestCase.deploy();
        }
    }

    public void undeployTests() throws PerfException {
        for (PerfTestCase perfTestCase : this.testsToRun) {
            perfTestCase.undeploy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void launchTests() {
        ArrayList<InterruptedException> throwables = new ArrayList<InterruptedException>();
        this.startTime = this.initialStartTime = System.currentTimeMillis();
        this.expectedEndTime = this.startTime + this.loadTime + this.warmupTime;
        this.lastPrintTime = this.startTime;
        long endOfLaunchPeriod = this.startTime + this.warmupTime;
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable throwable) {
                StressPerfTest.this.exit(throwable, "Error caught, aborting the test");
            }
        });
        StressPerfTest stressPerfTest = this;
        synchronized (stressPerfTest) {
            void var5_6;
            boolean bl = false;
            while (var5_6 < this.threadNb) {
                if (System.currentTimeMillis() > endOfLaunchPeriod) {
                    this.exit("Launch period is not long enough to complete the initial launch.Please decrease threadNb or increase launch period.");
                }
                this.launchOneTest((String)null, this.launched++);
                this.printStatus();
                try {
                    Thread.sleep(this.thinkTime);
                }
                catch (InterruptedException e) {
                    throwables.add(e);
                }
                ++var5_6;
            }
            this.initialLaunchCompleted = true;
        }
        do {
            try {
                Thread.sleep(this.timeBetweenVerifications);
            }
            catch (InterruptedException e) {
                throwables.add(e);
            }
            this.printStatus();
        } while (!this.testFinished);
        this.printResults();
        if (!throwables.isEmpty()) {
            System.err.println("Throables caught during test launch : ");
            for (Throwable throwable : throwables) {
                throwable.printStackTrace(System.err);
            }
        }
    }

    private void launchOneTest(String alias, long threadId) {
        PerfTestCase testToLaunch = null;
        String algoToExecute = this.algo;
        if (alias == null) {
            algoToExecute = ALGO_NB;
        }
        if (algoToExecute.equals(ALGO_NB)) {
            int testsToRunSize = this.testsToRun.size();
            int index = new Long(threadId % (long)testsToRunSize).intValue();
            testToLaunch = this.testsToRun.get(index);
        } else if (algoToExecute.equals(ALGO_TYPE)) {
            for (PerfTestCase perfTestCase : this.testsToRun) {
                if (!perfTestCase.getAlias().equals(alias)) continue;
                testToLaunch = perfTestCase;
                break;
            }
        }
        this.launchOneTest(testToLaunch, threadId);
    }

    private PerfTestCase launchOneTest(PerfTestCase perfTestCase, long threadId) {
        PerfTestCase newPerfTestCase = null;
        try {
            newPerfTestCase = (PerfTestCase)perfTestCase.getClass().newInstance();
        }
        catch (Exception e) {
            this.exit(e, "Problem while instantiating class of perftestCase : " + perfTestCase);
        }
        newPerfTestCase.setId(threadId);
        PerfTestCaseThread thread = new PerfTestCaseThread(this, newPerfTestCase);
        thread.start();
        if (this.printLaunched) {
            this.log("Launching thread " + threadId + " (" + perfTestCase.getAlias() + ")... ");
        }
        return newPerfTestCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(String processId, long threadId, String alias, long executionTime, Throwable t) {
        long currentTime = System.currentTimeMillis();
        boolean success = t == null;
        String logMessage = null;
        long nextThreadId = -1L;
        StressPerfTest stressPerfTest = this;
        synchronized (stressPerfTest) {
            ++this.finished;
            if (success) {
                ++this.successNb;
            } else {
                ++this.errorNb;
            }
            if (currentTime <= this.expectedEndTime) {
                if (this.launchPeriod && this.startTime + this.warmupTime <= currentTime) {
                    this.startTime = currentTime;
                    this.expectedEndTime = this.startTime + this.loadTime;
                    this.launchPeriod = false;
                    logMessage = "STARTING MEASURES";
                } else if (!this.launchPeriod && success) {
                    long processExecutionTimeTotal = this.executionTimes.get(alias);
                    this.executionTimes.put(alias, processExecutionTimeTotal + executionTime);
                    if (executionTime > this.worthTimes.get(alias) || this.worthTimes.get(alias) == -1L) {
                        this.worthTimes.put(alias, executionTime);
                    }
                    if (executionTime < this.bestTimes.get(alias)) {
                        this.bestTimes.put(alias, executionTime);
                    }
                    this.processSuccesses.put(alias, this.processSuccesses.get(alias) + 1L);
                    ++this.measuredInstances;
                }
                nextThreadId = this.launched++;
            } else if (!this.initialLaunchCompleted) {
                System.err.println("warmupTime + loadTime reached but initial launch not completed ! Please change values to have a coherent comportment !");
            } else {
                this.endTime = currentTime;
                this.testFinished = this.finished == this.launched;
            }
        }
        if (t != null) {
            this.log(t);
        }
        if (this.printFinished) {
            this.log("Finishing thread " + threadId + " (" + alias + ") in " + executionTime + " ms " + "at " + System.currentTimeMillis() + ", success = " + success);
        }
        if (logMessage != null) {
            this.log(logMessage);
        }
        if (nextThreadId != -1L) {
            this.launchOneTest(alias, nextThreadId);
        }
    }

    private void printStatus() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastPrintTime >= this.timeBetweenPrints) {
            this.log("finished : " + this.finished + ", running for " + Util.getDuration(currentTime - this.startTime) + ", remaining time : " + Util.getDuration(this.expectedEndTime - currentTime) + ", " + (this.launched - this.finished) + " running" + ", " + this.finished + " finished" + ", " + this.successNb + " success" + ", " + this.errorNb + " errors" + ", " + this.launched + " launched");
            this.lastPrintTime = currentTime;
        }
    }

    private void log(String message) {
        System.out.println(message);
    }

    private void log(Throwable t) {
        t.printStackTrace();
    }

    public static String formatFloat(float f) {
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
        return nf.format(f);
    }

    private void printResults() {
        this.log("\nAll finished !");
        long measuredTime = this.endTime - this.startTime;
        this.log(this.measuredInstances + " executed in " + Util.getDuration(measuredTime));
        if (this.measuredInstances > 0L) {
            long totalExecutionTimeAddition = 0L;
            HashMap<String, Long> averages = new HashMap<String, Long>();
            for (String processAlias : this.executionTimes.keySet()) {
                long processExecutionTotalTime = this.executionTimes.get(processAlias);
                long success = this.processSuccesses.get(processAlias);
                long average = 0L;
                if (success != 0L) {
                    average = processExecutionTotalTime / success;
                }
                averages.put(processAlias, average);
                this.log("\nResults for process " + processAlias + " " + success + " success");
                this.log("Average for process " + processAlias + " " + average + " ms");
                this.log("Best time for process " + processAlias + " " + this.bestTimes.get(processAlias) + "ms");
                this.log("Woth time for process " + processAlias + " " + this.worthTimes.get(processAlias) + "ms");
                totalExecutionTimeAddition += processExecutionTotalTime;
            }
            long instanceExecTime = totalExecutionTimeAddition / this.measuredInstances;
            this.log("\nExecution time average per instance for all processes = " + Util.getDuration(instanceExecTime));
            long instancesPerMinute = this.measuredInstances * 60000L / measuredTime;
            float instancesPerSecond = (float)this.measuredInstances * 60000.0f / (float)measuredTime / 60.0f;
            String xlsh = "XLSH;Algo;Tests;Thread Nb;Warmup;Think;Load;Total Instances (loadTime);Total Time;Avg Time/Instance (ms);Instances/mn;Instances/s;Errors";
            String xlsd = "XLSD;";
            xlsd = xlsd + this.algo + ";";
            xlsd = xlsd + this.getInitalArgValue("testsToRunClasses") + ";";
            xlsd = xlsd + this.threadNb + ";";
            xlsd = xlsd + this.warmupTime / 60000L + ";";
            xlsd = xlsd + this.thinkTime + ";";
            xlsd = xlsd + this.loadTime / 60000L + ";";
            xlsd = xlsd + this.measuredInstances + ";";
            xlsd = xlsd + (this.endTime - this.initialStartTime) / 60000L + ";";
            xlsd = xlsd + instanceExecTime + ";";
            xlsd = xlsd + instancesPerMinute + ";";
            xlsd = xlsd + StressPerfTest.formatFloat(instancesPerSecond) + ";";
            xlsd = xlsd + this.errorNb;
            for (String alias : this.aliasesMap.keySet()) {
                xlsh = xlsh + ";Avg Time/" + alias;
                xlsd = xlsd + ";";
                Long l = (Long)averages.get(alias);
                if (l == null) continue;
                xlsd = xlsd + l;
            }
            this.log("\n" + xlsh);
            this.log(xlsd);
        } else {
            this.log("This test was not long enough to start measuring intances...");
        }
    }

    private void parseArgs() throws PerfException {
        System.out.println(this.getClass() + ".parseArgs, args = " + this.initialArgs);
        for (String arg : this.initialArgs) {
            System.out.println(this.getClass() + ".parseArgs, arg = " + arg);
            String[] tmp = arg.split("=");
            if (tmp.length != 2) {
                throw new PerfException("Wrong arguments, a list of key=value is expected");
            }
            String key = tmp[0];
            String value = tmp[1];
            if (key.equals("threadNb")) {
                this.threadNb = new Integer(value);
                continue;
            }
            if (key.equals("printFinished")) {
                this.printFinished = new Boolean(value);
                continue;
            }
            if (key.equals("printLaunched")) {
                this.printLaunched = new Boolean(value);
                continue;
            }
            if (key.equals("timeBetweenVerifications")) {
                this.timeBetweenVerifications = Util.parseTime(value);
                continue;
            }
            if (key.equals("timeBetweenPrints")) {
                this.timeBetweenPrints = Util.parseTime(value);
                continue;
            }
            if (key.equals("testsToRunClasses")) {
                String[] aliases = value.split(",");
                if (aliases.length < 1) {
                    throw new PerfException("At least one test class is mandatory for arument testsToRunClasses");
                }
                this.testsToRun = new ArrayList<PerfTestCase>();
                for (int i = 0; i < aliases.length; ++i) {
                    String alias = aliases[i].trim();
                    if (this.aliasesMap.get(alias) != null) {
                        this.testsToRun.add(this.getPerftestcaseInstance(alias));
                        continue;
                    }
                    if (this.globalAliasesMap != null && this.globalAliasesMap.get(alias) != null) {
                        String[] aliasArray;
                        for (String alias2 : aliasArray = this.globalAliasesMap.get(alias)) {
                            this.testsToRun.add(this.getPerftestcaseInstance(alias2));
                        }
                        continue;
                    }
                    throw new PerfException("Invalid alias : " + alias + ", valid aliases : " + this.getAliases());
                }
                continue;
            }
            if (key.equals("thinkTime")) {
                this.thinkTime = Util.parseTime(value);
                continue;
            }
            if (key.equals("loadTime")) {
                this.loadTime = Util.parseTime(value);
                continue;
            }
            if (key.equals("warmupTime")) {
                this.warmupTime = Util.parseTime(value);
                continue;
            }
            if (key.equals("algo")) {
                if (value.equals(ALGO_TYPE)) {
                    this.algo = ALGO_TYPE;
                    continue;
                }
                if (value.equals(ALGO_NB)) {
                    this.algo = ALGO_NB;
                    continue;
                }
                throw new PerfException("Bad value for algo argument : " + value + ", one of the following is allowed : type, nb");
            }
            throw new PerfException("unknown argument : " + key);
        }
        if (this.testsToRun == null) {
            throw new PerfException("Missing arg : 'testsToRunClasses'");
        }
    }

    private PerfTestCase getPerftestcaseInstance(String alias) {
        String className = this.aliasesMap.get(alias);
        if (className == null) {
            this.exit("There is no class corresponding to alias : " + alias);
        }
        PerfTestCase perfTestCase = null;
        try {
            Class<?> clazz = Class.forName(className);
            if (!PerfTestCase.class.isAssignableFrom(clazz)) {
                throw new PerfException("Alias : " + alias + " maps to class : " + className + " which is not an instanceof Perftestcase.");
            }
            perfTestCase = (PerfTestCase)clazz.newInstance();
        }
        catch (Exception e) {
            this.exit(e, "Problem getting perftestcase instance : " + e);
        }
        if (!perfTestCase.getAlias().equals(alias)) {
            this.exit("Wrong alias ! Alias given in parameter (" + alias + ") corresponds to class : " + perfTestCase.getClass() + " but this class has the following alias : " + perfTestCase.getAlias());
        }
        this.executionTimes.put(alias, new Long(0L));
        this.bestTimes.put(alias, System.currentTimeMillis());
        this.worthTimes.put(alias, new Long(-1L));
        this.processSuccesses.put(alias, new Long(0L));
        return perfTestCase;
    }

    private String getAliases() {
        String all = "";
        for (String alias : this.aliasesMap.keySet()) {
            all = all + alias + ",";
        }
        if (this.globalAliasesMap != null) {
            for (String alias : this.globalAliasesMap.keySet()) {
                all = all + alias + ",";
            }
        }
        return all.substring(0, all.length() - 1);
    }

    private String getInitalArgValue(String argName) {
        for (String arg : this.initialArgs) {
            String[] tmp = arg.split("=");
            String key = tmp[0].trim();
            String value = tmp[1].trim();
            if (!key.equals(argName.trim())) continue;
            return value;
        }
        return null;
    }

    private void exit(String message) {
        this.exit(null, message);
    }

    private void exit(Throwable t, String message) {
        System.err.println("Fatal error, exiting... : " + message);
        if (t != null) {
            t.printStackTrace();
        }
        System.exit(1);
    }
}

