function UIUploadProcess(uploadId, formId, action) {
  this.listUpload = new Array();

  this.instance = "eXo.webui.UIUploadProcess"+uploadId;

  this.uploadId = uploadId;
  this.formIdToSubmitAfterUpload = formId;
  this.submitActionAfterUpload = action;

  this.initUploadEntry = function() {
		var uploadId = this.uploadId;

		var url = eXo.env.server.context + "/command?" ;
		url += "type=org.exoplatform.web.command.handler.UploadHandler&action=progress&uploadId="+uploadId ;
		var responseText = ajaxAsyncGetRequest(url, false);
	
		var response;
		try{
	    	    eval("response = "+responseText);
		}catch(err){
	    	    return;  
		}
		if(response.upload[uploadId] == undefined || response.upload[uploadId].percent == undefined) {
			this.createUploadEntry(uploadId);
		} else if(response.upload[uploadId].percent == 100)  {
			this.showUploaded(uploadId, decodeURIComponent(response.upload[uploadId].fileName));
		} 
  };

  this.createUploadEntry = function(uploadId) {
	  var iframe = document.getElementById(uploadId+'uploadFrame');
	  var idoc = iframe.contentWindow.document ;

	  var uploadAction = eXo.env.server.context + "/command?" ;
	  uploadAction += "type=org.exoplatform.web.command.handler.UploadHandler";
	  uploadAction += "&uploadId=" + uploadId+"&action=upload" ;

	  idoc.open();
	  idoc.write("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>");
	  idoc.write("<html xmlns='http://www.w3.org/1999/xhtml' xml:lang='en' lang='en'>");
	  idoc.write("<head>");
	  idoc.write("<style type='text/css'>");
	  idoc.write(".UploadButton {width: 20px; height: 20px; cursor: pointer; vertical-align: bottom;");
	  idoc.write(" background: url('/eXoResources/skin/DefaultSkin/webui/component/UIUpload/background/UpArrow16x16.gif') no-repeat left; }");
	  idoc.write("</style>");
	  idoc.write("<script type='text/javascript'>var eXo = parent.eXo</script>");
	  idoc.write("</head>");
	  idoc.write("<body style='margin: 0px; border: 0px;'>");
	  idoc.write("  <form id='"+uploadId+"' class='UIUploadForm' style='margin: 0px; padding: 0px' action='"+uploadAction+"' enctype='multipart/form-data' method='post'>");
	  idoc.write("    <input type='file' name='file' id='file' value='' onkeypress='return false;' />");
	  idoc.write("    <img class='UploadButton' onclick='"+this.instance+".upload(this, "+uploadId+");' src='/eXoResources/skin/sharedImages/Blank.gif'/>");
	  idoc.write("  </form>");
	  idoc.write("</body>");
	  idoc.write("</html>");
	  idoc.close();
  };

  this.validUpload = function() {
	 var list =  this.listUpload;
	 if(list.length < 1) {
		eXo.webui.UIForm.submitForm(this.formIdToSubmitAfterUpload, this.submitActionAfterUpload, true);  
	 }
  };

  this.refeshProgress = function(elementId) {
	  var list =  this.listUpload;
	  if(list.length < 1) return;
	  var url = eXo.env.server.context + "/command?" ;
	  url += "type=org.exoplatform.web.command.handler.UploadHandler&action=progress" ;

	  for(var i = 0; i < list.length; i++){
	    url = url + "&uploadId=" + list[i];
	  }

	  var responseText = ajaxAsyncGetRequest(url, false);
	  
	  if(list.length > 0) {
	    setTimeout(this.instance+".refeshProgress('" + elementId + "');", 1000); 
	  }
	    
	  var response;
	  try {
	    eval("response = "+responseText);
	  }catch(err) {
	    return;  
	  }

	  for(id in response.upload) {
	    var element = document.getElementById(id+"ProgressIframe");
	    var percent =   response.upload[id].percent;
	    var container = parent.document.getElementById(elementId);
	    var progressBarMiddle = eXo.core.DOMUtil.findFirstDescendantByClass(container, "div", "ProgressBarMiddle") ;
	    var blueProgressBar = eXo.core.DOMUtil.findFirstChildByClass(progressBarMiddle, "div", "BlueProgressBar") ;
	    var progressBarLabel = eXo.core.DOMUtil.findFirstChildByClass(blueProgressBar, "div", "ProgressBarLabel") ;
	    blueProgressBar.style.width = percent + "%" ;
	    progressBarLabel.innerHTML = percent + "%" ;
	  
	    if(percent == 100) { 
		this.showUploaded(id, "");
	    }
	  }
	  
	  if(this.listUpload.length < 1) return;

	  if (element){
	    element.innerHTML = "Uploaded "+ percent + "% " +
		                "<span onclick='parent."+this.instance+".abortUpload("+id+")'>Abort</span>";
	  }
  };

  this.showUploaded = function(id, fileName) {

	  this.listUpload.remove(id);
	  var container = parent.document.getElementById(id);
	  var element = document.getElementById(id+"ProgressIframe");
	  element.innerHTML =  "<span></span>";

	  var uploadIframe = eXo.core.DOMUtil.findDescendantById(container, id+"UploadIframe");
	  uploadIframe.style.display = "none";
	  var progressIframe = eXo.core.DOMUtil.findDescendantById(container, id+"ProgressIframe");
	  progressIframe.style.display = "none";

	  var selectFileFrame = eXo.core.DOMUtil.findFirstDescendantByClass(container, "div", "SelectFileFrame") ;
	  selectFileFrame.style.display = "block" ;
	  var fileNameLabel = eXo.core.DOMUtil.findFirstDescendantByClass(selectFileFrame, "div", "FileNameLabel") ;
	  if(fileName != null) fileNameLabel.innerHTML += " " + fileName;

	  var progressBarFrame = eXo.core.DOMUtil.findFirstDescendantByClass(container, "div", "ProgressBarFrame") ;
	  progressBarFrame.style.display = "none" ;
	  var tmp = element.parentNode;
	  var temp = tmp.parentNode;

	  this.validUpload();
  };

  this.abortUpload = function(id) {
	  this.listUpload.remove(id);
	  var url = eXo.env.server.context + "/command?" ;
	  url += "type=org.exoplatform.web.command.handler.UploadHandler&uploadId=" +id+"&action=abort" ;

	  var request =  eXo.core.Browser.createHttpRequest();
	  request.open('GET', url, false);
	  request.setRequestHeader("Cache-Control", "max-age=86400");
	  request.send(null);
	  
	  var container = parent.document.getElementById(id);
	  var uploadIframe =  eXo.core.DOMUtil.findDescendantById(container, id+"UploadIframe");
	  uploadIframe.style.display = "block";
	  this.createUploadEntry(id);
	  var progressIframe = eXo.core.DOMUtil.findDescendantById(container, id+"ProgressIframe");
	  progressIframe.style.display = "none";

	  var tmp = progressIframe.parentNode;
	  var temp = tmp.parentNode;

	  var progressBarFrame = eXo.core.DOMUtil.findFirstDescendantByClass(container, "div", "ProgressBarFrame") ;
	  progressBarFrame.style.display = "none" ;
	  var selectFileFrame = eXo.core.DOMUtil.findFirstDescendantByClass(container, "div", "SelectFileFrame") ;
	  selectFileFrame.style.display = "none" ;
	   
	  var  input = parent.document.getElementById('input' + id);
	  input.value = "false";
  };

  this.deleteUpload = function(id) {
	  var url = eXo.env.server.context + "/command?";
	  url += "type=org.exoplatform.web.command.handler.UploadHandler&uploadId=" +id+"&action=delete" ;

	  var request =  eXo.core.Browser.createHttpRequest();
	  request.open('GET', url, false);
	  request.setRequestHeader("Cache-Control", "max-age=86400");
	  request.send(null);
	  var DOMUtil = eXo.core.DOMUtil;
	  var container = parent.document.getElementById(id);
	  var uploadIframe =  DOMUtil.findDescendantById(container, id+"UploadIframe");
	  uploadIframe.style.display = "block";
	  this.createUploadEntry(id);
	  var progressIframe = DOMUtil.findDescendantById(container, id+"ProgressIframe");
	  progressIframe.style.display = "none";

	  var tmp = progressIframe.parentNode;
	  var temp = tmp.parentNode;
	  var progressBarFrame = DOMUtil.findFirstDescendantByClass(container, "div", "ProgressBarFrame") ;
	  progressBarFrame.style.display = "none" ;
	  var selectFileFrame = DOMUtil.findFirstDescendantByClass(container, "div", "SelectFileFrame") ;
	  selectFileFrame.style.display = "none" ;
	   
	  var  input = parent.document.getElementById('input' + id);
	  input.value = "false";
  } ;

  this.upload = function(clickEle, id) {
	  var DOMUtil = eXo.core.DOMUtil;  
	  var container = parent.document.getElementById(id);  
	  var uploadFrame = parent.document.getElementById(id+"uploadFrame");
	  var form = uploadFrame.contentWindow.document.getElementById(id);

	  var file  = DOMUtil.findDescendantById(form, "file");
	  if(file.value == null || file.value == '') return;  
	  var infoUploaded = eXo.core.DOMUtil.findFirstDescendantByClass(container, "div", "FileNameLabel") ;
	  var temp = file.value;

	  if (temp.indexOf('/') != -1) {
	    temp = temp.substr((temp.lastIndexOf('/') + 1), temp.length - 1) ;
	  }
	  
	  if (temp.indexOf('\\') != -1) {
	    temp = temp.substr((temp.lastIndexOf('\\') + 1), temp.length - 1) ;
	  }
	  
	  infoUploaded.innerHTML = temp ;

	  var progressBarFrame = DOMUtil.findFirstDescendantByClass(container, "div", "ProgressBarFrame") ;
	  progressBarFrame.style.display = "block" ;  
	  var progressBarMiddle = DOMUtil.findFirstDescendantByClass(container, "div", "ProgressBarMiddle") ;
	  var blueProgressBar = DOMUtil.findFirstChildByClass(progressBarMiddle, "div", "BlueProgressBar") ;
	  var progressBarLabel = DOMUtil.findFirstChildByClass(blueProgressBar, "div", "ProgressBarLabel") ;
	  blueProgressBar.style.width = "0%" ;
	  progressBarLabel.innerHTML = "0%" ;
	  
	  var  input = parent.document.getElementById('input' + id);
	  input.value = "true";
	  
	  var uploadIframe = DOMUtil.findDescendantById(container, id+"UploadIframe");
	  uploadIframe.style.display = "none";
	  var progressIframe = DOMUtil.findDescendantById(container, id+"ProgressIframe");
	  progressIframe.style.display = "none";

	  var tmp = progressIframe.parentNode;
	  var temp = tmp.parentNode;
	  
	  form.submit() ;
	  
	  var list = this.listUpload;
	  if(list.length == 0) {
	    this.listUpload.push(form.id);
	    setTimeout(this.instance+".refeshProgress('" + id + "');", 1000);
	  } else {
	    this.listUpload.push(form.id);  
	  }
	  
	  } ;
};

function UIUploadFactory() {
	this.getUIUploadProcess = function (uploadId, formId, action){
		return new UIUploadProcess(uploadId, formId, action);
	};
};

eXo.webui.UIUploadFactory = new UIUploadFactory();