/*
 * Copyright (C) 2012 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */
package org.ow2.orchestra.common.gwt.utils.client;

/**
 * @author Mathieu Crassin
 * 
 * Exception class used to define an error in orchestra management server side.
 */
@SuppressWarnings("serial")
public class OrchestraGwtException extends Exception {
  /**
   * @author Mathieu Crassin
   *
   * Details about the orchestra error.
   */
  private String details = null;

  /**
   * @author Mathieu Crassin
   *
   * Default constructor (ask during compilation).
   */
  public OrchestraGwtException() {
    super("Default orchestra management");
  }
  /**
   * @author Mathieu Crassin
   * @param maininfo : main information about the exception.
   * @param dtls : details about the exception.
   *
   * Constructor to define an orchestra exception.
   */
  public OrchestraGwtException(final String maininfo, final String dtls) {
    super(maininfo);
    this.details = dtls;
  }

  /**
     * @author Mathieu Crassin
     * @param maininfo : main information about the exception.
     * @param dtls : details about the exception.
     *
     * Constructor to define an orchestra exception.
     */
    public OrchestraGwtException(final String maininfo) {
      this(maininfo, null);
    }

  /**
   * @author Mathieu Crassin
   *
   * Get method of details object.
   */
  public String getDetails() {
    return details;
  }
}
