/*
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.common.gwt.utils.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.SimpleEventBus;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.ow2.orchestra.common.gwt.utils.client.events.CloseTabEvent;
import org.ow2.orchestra.common.gwt.utils.client.events.RenameTabEvent;

/**
 * @author Loic Albertin
 */
public class ClosableTabHeader extends Composite {
  interface ClosableTabHeaderUiBinder extends UiBinder<Widget, ClosableTabHeader> {
  }

  private static ClosableTabHeaderUiBinder ourUiBinder = GWT.create(ClosableTabHeaderUiBinder.class);

  public interface Resources extends ClientBundle {
    @Source("close.png")
    ImageResource closeImage();

    @Source("closeOver.png")
    ImageResource closeOverImage();
  }

  private static final Resources RESOURCES = GWT.create(ClosableTabHeader.Resources.class);

  @UiField
  Label label;
  @UiField
  Image button;

  @UiField
  TextBox inputText;

  private EventBus eventBus;

  private String key;

  private boolean allowRename;

  @UiConstructor
  public ClosableTabHeader(final String headerLabel) {
    this(headerLabel, new SimpleEventBus(), headerLabel);
  }

  @UiConstructor
  public ClosableTabHeader(final String headerLabel, final boolean isClosable) {
    this(headerLabel, isClosable, false);
  }

  @UiConstructor
  public ClosableTabHeader(final String headerLabel, final boolean isClosable, final boolean allowRename) {
    this(headerLabel, new SimpleEventBus(), headerLabel, isClosable, allowRename);
  }

  public ClosableTabHeader(final String headerLabel, final EventBus eventBus, final String key) {
    this(headerLabel, eventBus, key, false);
  }

  public ClosableTabHeader(final String headerLabel, final EventBus eventBus, final String key,
                           final boolean isClosable) {
    this(headerLabel, eventBus, key, isClosable, false);
  }

  public ClosableTabHeader(final String headerLabel, final EventBus eventBus, final String key,
                           final boolean isClosable, final boolean allowRename) {
    this.initWidget(ourUiBinder.createAndBindUi(this));
    label.setText(headerLabel);
    label.setTitle(headerLabel);
    this.eventBus = eventBus;
    this.key = key;
    this.button.setVisible(isClosable);
    this.allowRename = allowRename;
  }

  public EventBus getEventBus() {
    return eventBus;
  }

  public void setEventBus(EventBus eventBus) {
    this.eventBus = eventBus;
  }

  public Label getLabel() {
    return label;
  }

  @UiHandler("button")
  public void handleClickOnCloseButton(ClickEvent event) {
    eventBus.fireEvent(new CloseTabEvent(key));
  }

  @UiHandler("button")
  public void handleMouseOverOnCloseButton(MouseOverEvent event) {
    this.button.setResource(RESOURCES.closeOverImage());
  }

  @UiHandler("button")
  public void handleMouseOutOnCloseButton(MouseOutEvent event) {
    this.button.setResource(RESOURCES.closeImage());
  }

  @UiHandler("label")
  public void handleDoubleClickOnLabel(DoubleClickEvent event) {
    if (this.allowRename) {
      label.setVisible(false);
      inputText.setText(label.getText());
      inputText.setVisible(true);
    }
  }

  @UiHandler("inputText")
  public void handleChange(ChangeEvent event) {
    this.updateLabelAccordingTextInput();
  }

  @UiHandler("inputText")
  public void handleBlur(BlurEvent event) {
    this.updateLabelAccordingTextInput();
  }

  private void updateLabelAccordingTextInput() {
    final String oldValue = label.getText();
    final String newValue = inputText.getText();
    inputText.setVisible(false);
    label.setText(newValue);
    label.setVisible(true);
    eventBus.fireEvent(new RenameTabEvent(this.key, oldValue, newValue));
  }

}