/*
 * Copyright (C) 2011 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.common.gwt.utils.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Loic Albertin
 */
public class ScrollableTabLayoutPanelContainer extends Composite {

  interface ScrollableTabLayoutPanelContainerUiBinder extends UiBinder<Widget, ScrollableTabLayoutPanelContainer> {
  }

  private static ScrollableTabLayoutPanelContainerUiBinder ourUiBinder =
      GWT.create(ScrollableTabLayoutPanelContainerUiBinder.class);

  private ScrollableTabLayoutPanel scrollableTabLayoutPanel;

  @UiField
  LayoutPanel layoutPanel;

  @UiConstructor
  public  ScrollableTabLayoutPanelContainer(final ImageResource leftArrowImage,
                                  final ImageResource rightArrowImage, final Style.Unit barUnit, final double barHeight) {

    this.initWidget(ourUiBinder.createAndBindUi(this));

    scrollableTabLayoutPanel = new ScrollableTabLayoutPanel(barHeight, barUnit, leftArrowImage, rightArrowImage);
    layoutPanel.add(scrollableTabLayoutPanel);
  }

  public ScrollableTabLayoutPanel getScrollableTabLayoutPanel() {
    return scrollableTabLayoutPanel;
  }
}
