/*
 * Copyright (C) 2012 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */
package org.ow2.orchestra.common.gwt.utils.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.ow2.orchestra.common.gwt.utils.client.OrchestraGwtException;
import org.ow2.orchestra.util.Misc;

/**
 * Server that manage the relation between the client and the orchestra server.
 *
 * @author Mathieu Crassin
 */
public class OrchestraGwtServlet extends RemoteServiceServlet {
  private static final long serialVersionUID = -2830712026215016535L;

  private static final Logger LOG = Logger.getLogger(OrchestraGwtServlet.class.getName());

  private static class SessionAPIListener implements HttpSessionBindingListener, Serializable {

    private static final long serialVersionUID = -5971778668870938917L;
    private transient OrchestraGwtServlet orchestraGwtServlet;

    private SessionAPIListener(OrchestraGwtServlet orchestraGwtServlet) {
      this.orchestraGwtServlet = orchestraGwtServlet;
    }

    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
      //nothing to do
    }

    public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
      // called when session is invalid
      if (this.orchestraGwtServlet != null) {
        synchronized (this.orchestraGwtServlet.apisMap) {
          this.orchestraGwtServlet.apisMap.remove(this);
        }
      }
    }

  }

  final Map<SessionAPIListener, SessionAPIs> apisMap =
      new HashMap<OrchestraGwtServlet.SessionAPIListener, SessionAPIs>();

  protected SessionAPIs getSessionAPIs() throws OrchestraGwtException {
    HttpSession session = this.getThreadLocalRequest().getSession(true);
    SessionAPIs sessionAPIs = null;
    synchronized (this.apisMap) {
      SessionAPIListener sessionAPIListener = (SessionAPIListener) session.getAttribute(SessionAPIListener.class.getName());
      if (sessionAPIListener != null) {
        sessionAPIs = this.apisMap.get(sessionAPIListener);
      }
      if (sessionAPIs == null) {
        try {
          sessionAPIs = new SessionAPIs(this.getThreadLocalRequest().getRemoteUser());
          sessionAPIListener = new SessionAPIListener(this);
          this.apisMap.put(sessionAPIListener, sessionAPIs);
          session.setAttribute(SessionAPIListener.class.getName(), sessionAPIListener);
        } catch (final Exception e) {
          Misc.fastDynamicLog(
              OrchestraGwtServlet.LOG, Level.SEVERE,
              "Error while accessing to orchestra server !\n" + Misc.getStackTraceFrom(e));
          throw new OrchestraGwtException("Error while accessing to orchestra server !",
              "OrchestraGwtServlet - getAPIs :\n" + Misc.getStackTraceFrom(e));
        }
      }
    }
    return sessionAPIs;
  }

  public <T> T getAPI(Class<T> clazz) throws OrchestraGwtException {
    return this.getSessionAPIs().getAPI(clazz);
  }

}
