/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.common.gwt.utils.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.TabLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import org.ow2.orchestra.common.gwt.utils.client.events.MouseStillDownEvent;
import org.ow2.orchestra.common.gwt.utils.client.events.MouseStillDownTimer;

public class ScrollableTabLayoutPanel
extends TabLayoutPanel {
    private static final Resources RESOURCES = (Resources)GWT.create(Resources.class);
    private static final int IMAGE_PADDING_PIXELS = 4;
    private LayoutPanel panel;
    private FlowPanel tabBar;
    private Image scrollLeftButton;
    private Image scrollRightButton;
    private HandlerRegistration windowResizeHandler;
    private ImageResource leftArrowImage;
    private ImageResource rightArrowImage;
    private MouseStillDownTimer mouseStillDownTimer = new MouseStillDownTimer(200);

    public ScrollableTabLayoutPanel(double barHeight, Style.Unit barUnit, ImageResource leftArrowImage, ImageResource rightArrowImage) {
        super(barHeight, barUnit);
        this.panel = (LayoutPanel)this.getWidget();
        for (int i = 0; i < this.panel.getWidgetCount(); ++i) {
            Widget widget = this.panel.getWidget(i);
            if (!(widget instanceof FlowPanel)) continue;
            this.tabBar = (FlowPanel)widget;
            break;
        }
        this.leftArrowImage = leftArrowImage;
        this.rightArrowImage = rightArrowImage;
        this.initScrollButtons();
    }

    public void add(Widget child, Widget tab) {
        super.add(child, tab);
        this.checkIfScrollButtonsNecessary();
    }

    public boolean remove(Widget w) {
        boolean b = super.remove(w);
        this.checkIfScrollButtonsNecessary();
        return b;
    }

    protected void onLoad() {
        super.onLoad();
        if (this.windowResizeHandler == null) {
            this.windowResizeHandler = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

                public void onResize(ResizeEvent event) {
                    ScrollableTabLayoutPanel.this.checkIfScrollButtonsNecessary();
                }
            });
        }
    }

    protected void onUnload() {
        super.onUnload();
        if (this.windowResizeHandler != null) {
            this.windowResizeHandler.removeHandler();
            this.windowResizeHandler = null;
        }
    }

    public void handleScrollRequest(int diff) {
        Widget lastTab = this.getLastTab();
        if (lastTab == null) {
            return;
        }
        int newLeft = ScrollableTabLayoutPanel.parsePosition(this.tabBar.getElement().getStyle().getLeft()) + diff;
        int rightOfLastTab = this.getRightOfWidget(lastTab);
        if (newLeft > 0) {
            newLeft = 0;
        } else if (this.getTabBarWidth() - newLeft > rightOfLastTab + 20) {
            newLeft = -(rightOfLastTab - this.getTabBarWidth());
        }
        this.scrollTo(newLeft);
    }

    private void initScrollButtons() {
        this.scrollLeftButton = new Image(this.leftArrowImage);
        int leftImageWidth = this.scrollLeftButton.getWidth();
        this.panel.insert((Widget)this.scrollLeftButton, 0);
        this.panel.setWidgetLeftWidth((Widget)this.scrollLeftButton, 0.0, Style.Unit.PX, (double)leftImageWidth, Style.Unit.PX);
        this.panel.setWidgetTopHeight((Widget)this.scrollLeftButton, (double)(this.getTabBarHeight() / 2 + this.scrollLeftButton.getHeight() / 2), Style.Unit.PX, (double)this.scrollLeftButton.getWidth(), Style.Unit.PX);
        this.scrollLeftButton.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                ScrollableTabLayoutPanel.this.handleScrollRequest(40);
                ScrollableTabLayoutPanel.this.mouseStillDownTimer.registerHandler(new MouseStillDownEvent.OnMouseStillDownEventHandler(){

                    public void onMouseStillDown(MouseStillDownEvent event) {
                        ScrollableTabLayoutPanel.this.handleScrollRequest(40);
                    }
                });
            }
        });
        this.scrollLeftButton.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                ScrollableTabLayoutPanel.this.mouseStillDownTimer.stopRecurring();
            }
        });
        this.scrollLeftButton.setVisible(false);
        this.scrollRightButton = new Image(this.rightArrowImage);
        this.panel.insert((Widget)this.scrollRightButton, 0);
        this.panel.setWidgetRightWidth((Widget)this.scrollRightButton, 0.0, Style.Unit.PX, (double)this.scrollRightButton.getWidth(), Style.Unit.PX);
        this.panel.setWidgetTopHeight((Widget)this.scrollRightButton, (double)(this.getTabBarHeight() / 2 + this.scrollRightButton.getHeight() / 2), Style.Unit.PX, (double)this.scrollRightButton.getHeight(), Style.Unit.PX);
        this.scrollRightButton.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                ScrollableTabLayoutPanel.this.handleScrollRequest(-40);
                ScrollableTabLayoutPanel.this.mouseStillDownTimer.registerHandler(new MouseStillDownEvent.OnMouseStillDownEventHandler(){

                    public void onMouseStillDown(MouseStillDownEvent event) {
                        ScrollableTabLayoutPanel.this.handleScrollRequest(-40);
                    }
                });
            }
        });
        this.scrollRightButton.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                ScrollableTabLayoutPanel.this.mouseStillDownTimer.stopRecurring();
            }
        });
        this.scrollRightButton.setVisible(false);
    }

    private void checkIfScrollButtonsNecessary() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                boolean isScrolling = ScrollableTabLayoutPanel.this.isScrollingNecessary();
                if (ScrollableTabLayoutPanel.this.scrollRightButton.isVisible() && !isScrolling) {
                    ScrollableTabLayoutPanel.this.resetScrollPosition();
                }
                ScrollableTabLayoutPanel.this.scrollRightButton.setVisible(isScrolling);
                ScrollableTabLayoutPanel.this.scrollLeftButton.setVisible(isScrolling);
                if (isScrolling) {
                    ScrollableTabLayoutPanel.this.panel.setWidgetLeftRight((Widget)ScrollableTabLayoutPanel.this.tabBar, (double)ScrollableTabLayoutPanel.this.scrollLeftButton.getWidth(), Style.Unit.PX, (double)ScrollableTabLayoutPanel.this.scrollRightButton.getWidth(), Style.Unit.PX);
                } else {
                    ScrollableTabLayoutPanel.this.panel.setWidgetLeftRight((Widget)ScrollableTabLayoutPanel.this.tabBar, 0.0, Style.Unit.PX, 0.0, Style.Unit.PX);
                }
            }
        });
    }

    private void resetScrollPosition() {
        this.scrollTo(0);
    }

    private void scrollTo(int pos) {
        this.tabBar.getElement().getStyle().setLeft((double)pos, Style.Unit.PX);
    }

    private boolean isScrollingNecessary() {
        Widget lastTab = this.getLastTab();
        return lastTab != null && this.getRightOfWidget(lastTab) > this.getTabBarWidth();
    }

    private int getRightOfWidget(Widget widget) {
        return widget.getElement().getOffsetLeft() + widget.getElement().getOffsetWidth();
    }

    private int getTabBarWidth() {
        return this.tabBar.getElement().getParentElement().getClientWidth();
    }

    private int getTabBarHeight() {
        return this.tabBar.getElement().getParentElement().getClientHeight();
    }

    private Widget getLastTab() {
        if (this.tabBar.getWidgetCount() == 0) {
            return null;
        }
        return this.tabBar.getWidget(this.tabBar.getWidgetCount() - 1);
    }

    private static int parsePosition(String positionString) {
        int position;
        try {
            for (int i = 0; i < positionString.length(); ++i) {
                char c = positionString.charAt(i);
                if (c == '-' || c >= '0' && c <= '9') continue;
                positionString = positionString.substring(0, i);
            }
            position = Integer.parseInt(positionString);
        }
        catch (NumberFormatException ex) {
            position = 0;
        }
        return position;
    }

    private boolean isLeftOfWidgetVisible(Widget widget) {
        int firstVisiblePosition;
        int position = ScrollableTabLayoutPanel.parsePosition(this.tabBar.getElement().getStyle().getLeft());
        int leftOfWidget = widget.getElement().getOffsetLeft();
        return leftOfWidget > (firstVisiblePosition = -position);
    }

    private boolean isRightOfWidgetVisible(Widget widget) {
        int lastVisiblePosition;
        int tabBarWidth = this.getTabBarWidth();
        int position = ScrollableTabLayoutPanel.parsePosition(this.tabBar.getElement().getStyle().getLeft());
        int rightOfWidget = this.getRightOfWidget(widget);
        return rightOfWidget < (lastVisiblePosition = tabBarWidth - position);
    }

    public void selectTab(final int index, boolean fireEvents) {
        super.selectTab(index, fireEvents);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Widget widget = ScrollableTabLayoutPanel.this.tabBar.getWidget(index);
                int rightOfWidget = ScrollableTabLayoutPanel.this.getRightOfWidget(widget);
                int tabBarWidth = ScrollableTabLayoutPanel.this.getTabBarWidth();
                int position = ScrollableTabLayoutPanel.parsePosition(ScrollableTabLayoutPanel.this.tabBar.getElement().getStyle().getLeft());
                if (!ScrollableTabLayoutPanel.this.isRightOfWidgetVisible(widget)) {
                    ScrollableTabLayoutPanel.this.handleScrollRequest(tabBarWidth - position - rightOfWidget);
                }
                if (!ScrollableTabLayoutPanel.this.isLeftOfWidgetVisible(widget)) {
                    ScrollableTabLayoutPanel.this.scrollTo(-widget.getElement().getOffsetLeft());
                }
            }
        });
    }

    public static interface Resources
    extends ClientBundle {
        @ClientBundle.Source(value={"leftArrowImage.png"})
        public ImageResource leftArrowImage();

        @ClientBundle.Source(value={"rightArrowImage.png"})
        public ImageResource rightArrowImage();
    }
}

