/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.common.gwt.utils.client.ui.popup;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import org.ow2.orchestra.common.gwt.utils.client.OrchestraGwtException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Popup
extends Composite {
    private static PopupUIBinder popupUIBinder = (PopupUIBinder)GWT.create(PopupUIBinder.class);
    private static final Resources RESOURCES = (Resources)GWT.create(Resources.class);
    @UiField
    DialogBox dialogBox;
    @UiField
    Image errorImage;
    @UiField
    Image infoImage;
    @UiField
    Label infoLabel;
    @UiField
    DisclosurePanel disclosurePanel;
    @UiField
    TextArea detailsTextArea;
    @UiField
    PushButton closeButton;

    private Popup(PopupType popupType, String message, String details) {
        this.initWidget((Widget)popupUIBinder.createAndBindUi((Object)this));
        this.infoLabel.setText(message);
        this.disclosurePanel.getHeader().setStyleName(RESOURCES.popupStyle().buttonDeployStyle());
        if (details != null && !"".equals(details)) {
            this.disclosurePanel.setVisible(true);
            this.disclosurePanel.getHeader().asWidget().addStyleDependentName(RESOURCES.popupStyle().headerButtonDeployStyleTd());
            this.detailsTextArea.setText(details);
        }
        switch (popupType) {
            case ErrorPopup: {
                this.errorImage.setVisible(true);
                this.dialogBox.setText("Error!");
                this.dialogBox.getCaption().asWidget().addStyleName(RESOURCES.popupStyle().errorPopupDialogBoxCaption());
                break;
            }
            case InfoPopup: {
                this.infoImage.setVisible(true);
                this.dialogBox.setText("Information!");
                this.dialogBox.getCaption().asWidget().addStyleName(RESOURCES.popupStyle().infoPopupDialogBoxCaption());
            }
        }
        this.setDebugID();
        this.dialogBox.center();
        RESOURCES.popupStyle().ensureInjected();
    }

    @UiHandler(value={"closeButton"})
    public void handleClick(ClickEvent event) {
        this.dialogBox.hide();
    }

    @UiHandler(value={"disclosurePanel"})
    public void handleClose(CloseEvent<DisclosurePanel> event) {
        this.disclosurePanel.getHeaderTextAccessor().setText("More Details");
    }

    @UiHandler(value={"disclosurePanel"})
    public void handleOpen(OpenEvent<DisclosurePanel> event) {
        this.disclosurePanel.getHeaderTextAccessor().setText("Less Details");
    }

    public static void show(PopupType popupType, String message, String details) {
        new Popup(popupType, message, details);
    }

    public static void showError(String message, String details) {
        Popup.show(PopupType.ErrorPopup, message, details);
    }

    public static void showError(String message) {
        Popup.showError(message, null);
    }

    public static void showInfo(String message, String details) {
        Popup.show(PopupType.InfoPopup, message, details);
    }

    public static void showInfo(String message) {
        Popup.showInfo(message, null);
    }

    public static void show(OrchestraGwtException exception) {
        Popup.showError(exception.getMessage(), exception.getDetails());
    }

    private void setDebugID() {
        this.dialogBox.ensureDebugId("popupId");
        this.infoLabel.ensureDebugId("popupInfoLabelId");
        this.errorImage.ensureDebugId("popupErrorImageId");
        this.infoImage.ensureDebugId("popupInfoImageId");
        this.detailsTextArea.ensureDebugId("popupDetailsTextareaId");
        this.closeButton.ensureDebugId("popupCloseButtonId");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PopupType {
        ErrorPopup,
        InfoPopup;

    }

    static interface Style
    extends CssResource {
        public String closePushButtonStyle();

        public String infoLabelStyle();

        public String buttonDeployStyle();

        public String infoPopupDialogBoxCaption();

        public String errorPopupDialogBoxCaption();

        public String headerButtonDeployStyleTd();
    }

    static interface Resources
    extends ClientBundle {
        @ClientBundle.Source(value={"error.png"})
        public ImageResource errorImage();

        @ClientBundle.Source(value={"info.png"})
        public ImageResource infoImage();

        @ClientBundle.Source(value={"close_button.png"})
        public ImageResource closePushButton();

        @ClientBundle.Source(value={"close_button_hover.png"})
        public ImageResource closePushButtonHover();

        @ClientBundle.Source(value={"Popup.css"})
        public Style popupStyle();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface PopupUIBinder
    extends UiBinder<Widget, Popup> {
    }
}

