/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.common.gwt.utils.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.ow2.orchestra.common.gwt.utils.client.OrchestraGwtException;
import org.ow2.orchestra.common.gwt.utils.server.SessionAPIs;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrchestraGwtServlet
extends RemoteServiceServlet {
    private static final long serialVersionUID = -2830712026215016535L;
    private static final Logger LOG = Logger.getLogger(OrchestraGwtServlet.class.getName());
    final Map<SessionAPIListener, SessionAPIs> apisMap = new HashMap<SessionAPIListener, SessionAPIs>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionAPIs getSessionAPIs() throws OrchestraGwtException {
        HttpSession session = this.getThreadLocalRequest().getSession(true);
        SessionAPIs sessionAPIs = null;
        Map<SessionAPIListener, SessionAPIs> map = this.apisMap;
        synchronized (map) {
            SessionAPIListener sessionAPIListener = (SessionAPIListener)session.getAttribute(SessionAPIListener.class.getName());
            if (sessionAPIListener != null) {
                sessionAPIs = this.apisMap.get(sessionAPIListener);
            }
            if (sessionAPIs == null) {
                try {
                    sessionAPIs = new SessionAPIs(this.getThreadLocalRequest().getRemoteUser());
                    sessionAPIListener = new SessionAPIListener(this);
                    this.apisMap.put(sessionAPIListener, sessionAPIs);
                    session.setAttribute(SessionAPIListener.class.getName(), (Object)sessionAPIListener);
                }
                catch (Exception e) {
                    Misc.fastDynamicLog((Logger)LOG, (Level)Level.SEVERE, (String)("Error while accessing to orchestra server !\n" + Misc.getStackTraceFrom((Throwable)e)), (Object[])new Object[0]);
                    throw new OrchestraGwtException("Error while accessing to orchestra server !", "OrchestraGwtServlet - getAPIs :\n" + Misc.getStackTraceFrom((Throwable)e));
                }
            }
        }
        return sessionAPIs;
    }

    public <T> T getAPI(Class<T> clazz) throws OrchestraGwtException {
        return this.getSessionAPIs().getAPI(clazz);
    }

    private static class SessionAPIListener
    implements HttpSessionBindingListener,
    Serializable {
        private static final long serialVersionUID = -5971778668870938917L;
        private transient OrchestraGwtServlet orchestraGwtServlet;

        private SessionAPIListener(OrchestraGwtServlet orchestraGwtServlet) {
            this.orchestraGwtServlet = orchestraGwtServlet;
        }

        public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
            if (this.orchestraGwtServlet != null) {
                Map<SessionAPIListener, SessionAPIs> map = this.orchestraGwtServlet.apisMap;
                synchronized (map) {
                    this.orchestraGwtServlet.apisMap.remove(this);
                }
            }
        }
    }
}

