/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.common.gwt.utils.server;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.BindingProvider;
import org.ow2.orchestra.common.gwt.utils.client.OrchestraGwtException;
import org.ow2.orchestra.facade.AccessorUtil;
import org.ow2.orchestra.facade.InstanceManagementAPI;
import org.ow2.orchestra.facade.ManagementAPI;
import org.ow2.orchestra.facade.QueryDefinitionAPI;
import org.ow2.orchestra.facade.QueryRuntimeAPI;
import org.ow2.orchestra.facade.exception.OrchestraException;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.ws_ht.B4PAccessorUtil;
import org.ow2.orchestra.ws_ht.api.wsdl.TaskOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionAPIs {
    private static final Logger LOG = Logger.getLogger(SessionAPIs.class.getName());
    private static final String DEFAULT_USER_CONFIG_FILE = "conf/user-environments.properties";
    private static final String DEFAULT_ORCHESTRA_PROPERTIES_FILE = "conf/orchestra.properties";
    private static final String DEFAULT_ORCHESTRA_PROPERTIES_RESOURCE = "orchestra.properties";
    private static final String ORCHESTRA_PROPERTIES_FILE_PROPERTY = "orchestra.properties.file";
    private static final String ENV_USER_CONFIG_FILE_PROPERTY = "orchestra.user-environments.file";
    protected String serviceUrl = null;
    protected String objectName = null;
    protected String orchestraUrl = null;
    protected Properties orchestraProperties = null;
    private QueryRuntimeAPI queryRuntimeAPI;
    private QueryDefinitionAPI queryDefinitionAPI;
    private InstanceManagementAPI instanceManagementAPI;
    private ManagementAPI managementAPI;
    private TaskOperations taskOperations;

    protected SessionAPIs(String userName) throws OrchestraException, OrchestraGwtException {
        this.initializeOrchestraProperties(userName);
        this.queryRuntimeAPI = AccessorUtil.getQueryRuntimeAPI((String)this.serviceUrl, (String)this.objectName);
        this.queryDefinitionAPI = AccessorUtil.getQueryDefinitionAPI((String)this.serviceUrl, (String)this.objectName);
        this.instanceManagementAPI = AccessorUtil.getInstanceManagementAPI((String)this.serviceUrl, (String)this.objectName);
        this.managementAPI = AccessorUtil.getManagementAPI((String)this.serviceUrl, (String)this.objectName);
        this.getTaskOperationsAPI(userName);
    }

    protected void getTaskOperationsAPI(String userName) {
        if (this.managementAPI.isExtensionSupported("http://www.example.org/WS-HT")) {
            this.taskOperations = B4PAccessorUtil.getTaskOperationsAPI((String)this.orchestraUrl);
            BindingProvider bp = (BindingProvider)this.taskOperations;
            bp.getRequestContext().put("javax.xml.ws.security.auth.username", userName);
            bp.getRequestContext().put("javax.xml.ws.security.auth.password", userName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeOrchestraProperties(String userName) throws OrchestraGwtException {
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            File userEnvFile = new File(System.getProperty(ENV_USER_CONFIG_FILE_PROPERTY, DEFAULT_USER_CONFIG_FILE));
            if (userEnvFile.exists()) {
                Properties userProperties = new Properties();
                FileInputStream fip = new FileInputStream(userEnvFile);
                try {
                    userProperties.load(fip);
                }
                finally {
                    fip.close();
                }
                if (userName != null && userProperties.containsKey(userName)) {
                    String userEnv = userProperties.getProperty(userName);
                    File userOrchestraProperties = new File(new File(userEnvFile.getParentFile(), userEnv).getParentFile(), DEFAULT_ORCHESTRA_PROPERTIES_RESOURCE);
                    if (userOrchestraProperties.exists()) {
                        inputStream = new FileInputStream(userOrchestraProperties);
                    }
                }
            }
            if (inputStream == null) {
                File file = new File(System.getProperty(ORCHESTRA_PROPERTIES_FILE_PROPERTY, DEFAULT_ORCHESTRA_PROPERTIES_FILE));
                inputStream = file.exists() ? new FileInputStream(file) : Thread.currentThread().getContextClassLoader().getResourceAsStream(DEFAULT_ORCHESTRA_PROPERTIES_RESOURCE);
            }
            properties.load(inputStream);
            this.orchestraProperties = properties;
            this.serviceUrl = properties.getProperty("orchestra.jmx.serviceUrl");
            this.objectName = properties.getProperty("orchestra.jmx.objectName");
            this.orchestraUrl = "http://" + properties.getProperty("orchestra.servlet.host") + ":" + properties.getProperty("orchestra.servlet.port") + "/" + properties.getProperty("orchestra.servlet.path");
        }
        catch (IOException e) {
            try {
                Misc.fastDynamicLog((Logger)LOG, (Level)Level.SEVERE, (String)("OrchestraManagement - getOrchestraProperties :Unable to load property file !\n" + Misc.getStackTraceFrom((Throwable)e)), (Object[])new Object[0]);
                throw new OrchestraGwtException("Unable to load property file !", "OrchestraManagement - getOrchestraProperties : Unable to load property file !\n" + Misc.getStackTraceFrom((Throwable)e));
            }
            catch (Throwable throwable) {
                Misc.close(inputStream);
                throw throwable;
            }
        }
        Misc.close((Closeable)inputStream);
    }

    public <T> T getAPI(Class<T> clazz) {
        if (clazz.equals(QueryRuntimeAPI.class)) {
            return (T)this.queryRuntimeAPI;
        }
        if (clazz.equals(QueryDefinitionAPI.class)) {
            return (T)this.queryDefinitionAPI;
        }
        if (clazz.equals(ManagementAPI.class)) {
            return (T)this.managementAPI;
        }
        if (clazz.equals(InstanceManagementAPI.class)) {
            return (T)this.instanceManagementAPI;
        }
        if (clazz.equals(TaskOperations.class)) {
            return (T)this.taskOperations;
        }
        return null;
    }

    public String getOrchestraUrl() {
        return this.orchestraUrl;
    }

    public Properties getOrchestraProperties() {
        return this.orchestraProperties;
    }
}

