/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.DriverManagerDataSource;
import com.mchange.v2.c3p0.PoolBackedDataSource;
import com.mchange.v2.c3p0.PoolConfig;
import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.WrapperConnectionPoolDataSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;

public final class DataSources {
    public static DataSource unpooledDataSource(String jdbcUrl) throws SQLException {
        return DataSources.unpooledDataSource(jdbcUrl, new Properties());
    }

    public static DataSource unpooledDataSource(String jdbcUrl, String user, String password) throws SQLException {
        Properties props = new Properties();
        props.put("user", user);
        props.put("password", password);
        return DataSources.unpooledDataSource(jdbcUrl, props);
    }

    public static DataSource unpooledDataSource(String jdbcUrl, Properties driverProps) throws SQLException {
        DriverManagerDataSource out = new DriverManagerDataSource();
        out.setJdbcUrl(jdbcUrl);
        out.setProperties(driverProps);
        return out;
    }

    public static DataSource pooledDataSource(DataSource unpooledDataSource) throws SQLException {
        return DataSources.pooledDataSource(unpooledDataSource, PoolConfig.DEFAULTS);
    }

    public static DataSource pooledDataSource(DataSource unpooledDataSource, int statement_cache_size) throws SQLException {
        PoolConfig pcfg = new PoolConfig();
        pcfg.setMaxStatements(statement_cache_size);
        return DataSources.pooledDataSource(unpooledDataSource, pcfg);
    }

    public static DataSource pooledDataSource(DataSource unpooledDataSource, PoolConfig pcfg) throws SQLException {
        try {
            WrapperConnectionPoolDataSource wcpds = new WrapperConnectionPoolDataSource();
            wcpds.setNestedDataSource(unpooledDataSource);
            wcpds.setMaxStatements(pcfg.getMaxStatements());
            wcpds.setInitialPoolSize(pcfg.getInitialPoolSize());
            wcpds.setMinPoolSize(pcfg.getMinPoolSize());
            wcpds.setMaxPoolSize(pcfg.getMaxPoolSize());
            wcpds.setIdleConnectionTestPeriod(pcfg.getIdleConnectionTestPeriod());
            wcpds.setMaxIdleTime(pcfg.getMaxIdleTime());
            wcpds.setPropertyCycle(pcfg.getPropertyCycle());
            wcpds.setAcquireIncrement(pcfg.getAcquireIncrement());
            wcpds.setConnectionTesterClassName(pcfg.getConnectionTesterClassName());
            wcpds.setTestConnectionOnCheckout(pcfg.isTestConnectionOnCheckout());
            wcpds.setAutoCommitOnClose(pcfg.isAutoCommitOnClose());
            wcpds.setForceIgnoreUnresolvedTransactions(pcfg.isForceIgnoreUnresolvedTransactions());
            wcpds.setFactoryClassLocation(pcfg.getFactoryClassLocation());
            PoolBackedDataSource nascent_pbds = new PoolBackedDataSource();
            nascent_pbds.setConnectionPoolDataSource(wcpds);
            nascent_pbds.setNumHelperThreads(pcfg.getNumHelperThreads());
            nascent_pbds.setFactoryClassLocation(pcfg.getFactoryClassLocation());
            return nascent_pbds;
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
            PropertyChangeEvent evt = e.getPropertyChangeEvent();
            throw new SQLException("Illegal value attempted for property " + evt.getPropertyName() + ": " + evt.getNewValue());
        }
    }

    public static DataSource pooledDataSource(DataSource unpooledDataSource, Properties props) throws SQLException {
        return DataSources.pooledDataSource(unpooledDataSource, new PoolConfig(props));
    }

    public static void destroy(DataSource pooledDataSource) throws SQLException {
        DataSources.destroy(pooledDataSource, false);
    }

    public static void forceDestroy(DataSource pooledDataSource) throws SQLException {
        DataSources.destroy(pooledDataSource, true);
    }

    private static void destroy(DataSource pooledDataSource, boolean force) throws SQLException {
        ConnectionPoolDataSource cpds;
        if (pooledDataSource instanceof PoolBackedDataSource && (cpds = ((PoolBackedDataSource)pooledDataSource).getConnectionPoolDataSource()) instanceof WrapperConnectionPoolDataSource) {
            DataSources.destroy(((WrapperConnectionPoolDataSource)cpds).getNestedDataSource(), force);
        }
        if (pooledDataSource instanceof PooledDataSource) {
            ((PooledDataSource)pooledDataSource).close(force);
        }
    }

    private DataSources() {
    }
}

