/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.command.handler;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Widgets;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.command.Command;

public class GetWidgetContainerHandler
extends Command {
    public void execute(WebAppController controller, HttpServletRequest req, HttpServletResponse res) throws Exception {
        PrintWriter writer = res.getWriter();
        try {
            ((Writer)writer).append(this.getWidgetContainers(req));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    private StringBuilder getWidgetContainers(HttpServletRequest req) throws Exception {
        PortalContainer container = PortalContainer.getInstance();
        DataStorage dataService = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
        String userWidgetsId = "user::" + req.getRemoteUser();
        StringBuilder value = new StringBuilder();
        value.append("{\"widgetContainers\": [\n");
        Widgets widgets = dataService.getWidgets(userWidgetsId);
        if (widgets != null) {
            ArrayList widgetContainers = widgets.getChildren();
            for (int i = 0; i < widgetContainers.size(); ++i) {
                value.append(" {");
                value.append("\n          \"cId\": \"").append(((Container)widgetContainers.get(i)).getId()).append("\",");
                value.append("\n          \"cName\": \"").append(((Container)widgetContainers.get(i)).getName()).append("\",");
                value.append("\n          \"cDescription\": \"").append(((Container)widgetContainers.get(i)).getDescription()).append("\"\n");
                value.append("      }");
                if (i < widgetContainers.size() - 1) {
                    value.append(",\n");
                    continue;
                }
                value.append("\n");
            }
        }
        value.append("]}\n");
        return value;
    }
}

