/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.organization;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInputContainer;
import org.exoplatform.webui.form.UIFormPopupWindow;
import org.exoplatform.webui.organization.UIGroupSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/organization/webui/component/UIAccessGroup.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={DeleteActionListener.class}, confirm="UIAccessGroup.deleteAccessGroup"), @EventConfig(listeners={SelectGroupActionListener.class})})
public class UIAccessGroup
extends UIFormInputContainer<String> {
    public UIAccessGroup() throws Exception {
        super(null, null);
        UIGrid uiGrid = (UIGrid)this.addChild(UIGrid.class, null, "TableGroup");
        uiGrid.configure("id", new String[]{"id", "label", "description"}, new String[]{"Delete"});
        uiGrid.getUIPageIterator().setPageList((PageList)new ObjectPageList(new ArrayList(), 10));
        UIFormPopupWindow uiPopup = (UIFormPopupWindow)this.addChild(UIFormPopupWindow.class, null, "UIGroupSelector");
        uiPopup.setWindowSize(540, 0);
        UIGroupSelector uiGroupSelector = (UIGroupSelector)this.createUIComponent(UIGroupSelector.class, null, null);
        uiPopup.setUIComponent((UIComponent)uiGroupSelector);
    }

    public void configure(String iname, String bfield) {
        this.setName(iname);
        this.setBindingField(bfield);
    }

    public void addGroup(Group ... groups) throws Exception {
        ArrayList<Group> list = new ArrayList<Group>();
        UIPageIterator uiIterator = ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator();
        list.addAll(uiIterator.getPageList().getAll());
        for (Group group : groups) {
            if (!this.checkAvailable(group)) continue;
            list.add(group);
        }
        uiIterator.setPageList((PageList)new ObjectPageList(list, 10));
    }

    private boolean checkAvailable(Group group) throws Exception {
        ArrayList list = new ArrayList();
        UIPageIterator uiIterator = ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator();
        list.addAll(uiIterator.getPageList().getAll());
        for (Object ele : list) {
            if (!((Group)ele).getId().equals(group.getId())) continue;
            return false;
        }
        return true;
    }

    public void clearGroups() throws Exception {
        ArrayList list = new ArrayList();
        UIPageIterator uiIterator = ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator();
        uiIterator.setPageList((PageList)new ObjectPageList(list, 10));
    }

    public String[] getAccessGroup() throws Exception {
        UIPageIterator uiIterator = ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator();
        List values = uiIterator.getPageList().getAll();
        String[] groups = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            Group group = (Group)values.get(i);
            groups[i] = group.getId();
        }
        return groups;
    }

    public void setGroups(String[] groups) throws Exception {
        ArrayList<Group> list = new ArrayList<Group>();
        UIPageIterator uiIterator = ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator();
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        for (String id : groups) {
            Group group = service.getGroupHandler().findGroupById(id);
            list.add(group);
        }
        uiIterator.setPageList((PageList)new ObjectPageList(list, 10));
    }

    public Class<String> getTypeValue() {
        return String.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIAccessGroup> {
        public void execute(Event<UIAccessGroup> event) throws Exception {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectGroupActionListener
    extends EventListener<UIGroupSelector> {
        public void execute(Event<UIGroupSelector> event) throws Exception {
            UIGroupSelector uiGroupSelector = (UIGroupSelector)((Object)event.getSource());
            if (uiGroupSelector.getSelectedGroup() == null) {
                return;
            }
            UIAccessGroup uiAccessGroup = (UIAccessGroup)uiGroupSelector.getAncestorOfType(UIAccessGroup.class);
            Group group = uiGroupSelector.getSelectedGroup();
            if (group.getLabel() == null) {
                group.setLabel("");
            }
            if (group.getDescription() == null) {
                group.setDescription("");
            }
            uiAccessGroup.addGroup(group);
        }
    }
}

