/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.NumericFunction;

public class Atan2
extends NumericFunction {
    public Eval evaluate(Eval[] operands, int srcRow, short srcCol) {
        double d0 = 0.0;
        double d1 = 0.0;
        ErrorEval retval = null;
        switch (operands.length) {
            default: {
                retval = ErrorEval.VALUE_INVALID;
                break;
            }
            case 2: {
                NumericValueEval ne;
                ValueEval ve = this.singleOperandEvaluate(operands[0], srcRow, srcCol);
                if (ve instanceof NumericValueEval) {
                    ne = (NumericValueEval)ve;
                    d0 = ne.getNumberValue();
                } else if (!(ve instanceof BlankEval)) {
                    retval = ErrorEval.NUM_ERROR;
                }
                if (retval != null) break;
                ve = this.singleOperandEvaluate(operands[1], srcRow, srcCol);
                if (ve instanceof NumericValueEval) {
                    ne = (NumericValueEval)ve;
                    d1 = ne.getNumberValue();
                    break;
                }
                if (ve instanceof BlankEval) break;
                retval = ErrorEval.NUM_ERROR;
            }
        }
        if (retval == null) {
            double d = d0 == d1 && d1 == 0.0 ? Double.NaN : Math.atan2(d1, d0);
            retval = Double.isNaN(d) || Double.isInfinite(d) ? ErrorEval.NUM_ERROR : new NumberEval(d);
        }
        return retval;
    }
}

