/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.model.SelectItemCategory;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInputBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/webui/form/UIFormInputItemSelector.gtmpl")
public class UIFormInputItemSelector
extends UIFormInputBase<Object> {
    private Class type_;
    protected List<SelectItemCategory> categories_ = new ArrayList<SelectItemCategory>();

    public UIFormInputItemSelector(String name, String bindingField) throws Exception {
        super(name, bindingField, Object.class);
        this.setComponentConfig(this.getClass(), null);
    }

    public List<SelectItemCategory> getItemCategories() {
        return this.categories_;
    }

    public void setItemCategories(List<SelectItemCategory> categories) {
        this.categories_ = categories;
        boolean selected = false;
        for (SelectItemCategory ele : categories) {
            if (!ele.isSelected()) continue;
            if (selected) {
                ele.setSelected(false);
                continue;
            }
            selected = true;
        }
        if (!selected) {
            this.categories_.get(0).setSelected(true);
        }
    }

    public SelectItemCategory getSelectedCategory() {
        for (SelectItemCategory category : this.categories_) {
            if (!category.isSelected()) continue;
            return category;
        }
        if (this.categories_.size() > 0) {
            SelectItemCategory category = this.categories_.get(0);
            category.setSelected(true);
            ((SelectItemOption)category.getSelectItemOptions().get(0)).setSelected(true);
            return category;
        }
        return null;
    }

    public SelectItemOption getSelectedItemOption() {
        SelectItemCategory selectedCategory = this.getSelectedCategory();
        if (selectedCategory == null) {
            return null;
        }
        return selectedCategory.getSelectedItemOption();
    }

    @Override
    public Object getValue() {
        SelectItemCategory selectedCategory = this.getSelectedCategory();
        if (selectedCategory == null) {
            return null;
        }
        SelectItemOption selectedItem = selectedCategory.getSelectedItemOption();
        if (selectedItem == null) {
            return null;
        }
        return selectedItem.getValue();
    }

    public UIFormInputItemSelector setValue(Object input) {
        for (SelectItemCategory category : this.categories_) {
            category.setSelected(this.isSelectItemCategory(category, input));
        }
        return this;
    }

    @Override
    public Class getTypeValue() {
        if (this.type_ != null) {
            return this.type_;
        }
        if (this.getSelectedCategory() == null || this.getSelectedCategory().getSelectedItemOption() == null || this.getSelectedCategory().getSelectedItemOption().getValue() == null) {
            return this.typeValue_;
        }
        return this.getSelectedCategory().getSelectedItemOption().getValue().getClass();
    }

    public void setTypeValue(Class type) {
        this.type_ = type;
    }

    private boolean isSelectItemCategory(SelectItemCategory category, Object input) {
        List options = category.getSelectItemOptions();
        for (SelectItemOption option : options) {
            if (!option.getValue().equals(input)) continue;
            option.setSelected(true);
            return true;
        }
        return category.getName().equals(input);
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) throws Exception {
        if (input == null || String.valueOf(input).length() < 1) {
            return;
        }
        this.setValue(input);
    }
}

