/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.exoplatform.portal.webui.application.UIApplication;
import org.exoplatform.portal.webui.application.UIPortletActionListener;
import org.exoplatform.portal.webui.application.UIPortletLifecycle;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalComponentActionListener;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.PortletContainerService;
import org.exoplatform.services.portletcontainer.pci.ExoWindowID;
import org.exoplatform.services.portletcontainer.pci.PortletData;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIPortletLifecycle.class, template="system:/groovy/portal/webui/application/UIPortlet.gtmpl", events={@EventConfig(listeners={UIPortletActionListener.RenderActionListener.class}), @EventConfig(listeners={UIPortletActionListener.ChangePortletModeActionListener.class}), @EventConfig(listeners={UIPortletActionListener.ChangeWindowStateActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.DeleteComponentActionListener.class}, confirm="UIPortlet.deletePortlet"), @EventConfig(listeners={UIPortletActionListener.EditPortletActionListener.class}), @EventConfig(phase=Event.Phase.PROCESS, listeners={UIPortletActionListener.ProcessActionActionListener.class}), @EventConfig(phase=Event.Phase.PROCESS, listeners={UIPortletActionListener.ServeResourceActionListener.class}), @EventConfig(phase=Event.Phase.PROCESS, listeners={UIPortletActionListener.ProcessEventsActionListener.class})})
public class UIPortlet
extends UIApplication {
    protected static Log log = ExoLogger.getLogger((String)"portal:UIPortlet");
    private String theme_;
    public static final String DEFAULT_THEME = "Default:DefaultTheme::Vista:VistaTheme::Mac:MacTheme";
    private String windowId;
    private String portletStyle;
    private boolean showPortletMode = true;
    private Map<String, String[]> renderParametersMap_;
    private ExoWindowID exoWindowId_;
    private PortletMode currentPortletMode_ = PortletMode.VIEW;
    private WindowState currentWindowState_ = WindowState.NORMAL;
    private List<String> supportModes_;
    private List supportedProcessingEvents_;
    private List supportedPublicParams_;
    private boolean portletInPortal_ = true;

    public String getId() {
        return this.exoWindowId_.getUniqueID();
    }

    public String getWindowId() {
        return this.windowId;
    }

    public void setWindowId(String s) {
        this.windowId = s;
        this.exoWindowId_ = new ExoWindowID(this.windowId);
    }

    public String getPortletStyle() {
        return this.portletStyle;
    }

    public void setPortletStyle(String s) {
        this.portletStyle = s;
    }

    public boolean getShowPortletMode() {
        return this.showPortletMode;
    }

    public void setShowPortletMode(Boolean b) {
        this.showPortletMode = b;
    }

    public void setPortletInPortal(boolean b) {
        this.portletInPortal_ = b;
    }

    public boolean isPortletInPortal() {
        return this.portletInPortal_;
    }

    public String getTheme() {
        if (this.theme_ == null || this.theme_.trim().length() < 1) {
            return DEFAULT_THEME;
        }
        return this.theme_;
    }

    public void setTheme(String theme) {
        this.theme_ = theme;
    }

    public String getSuitedTheme(String skin) {
        Map<String, String> themeMap;
        if (skin == null) {
            skin = ((UIPortalApplication)this.getAncestorOfType(UIPortalApplication.class)).getSkin();
        }
        if ((themeMap = this.stringToThemeMap(this.getTheme())).containsKey(skin)) {
            return themeMap.get(skin);
        }
        return DEFAULT_THEME.split(":")[1];
    }

    public void putSuitedTheme(String skin, String theme) {
        if (skin == null) {
            skin = ((UIPortalApplication)this.getAncestorOfType(UIPortalApplication.class)).getSkin();
        }
        Map<String, String> themeMap = this.stringToThemeMap(this.getTheme());
        themeMap.put(skin, theme);
        this.setTheme(this.themeMapToString(themeMap));
    }

    private String themeMapToString(Map<String, String> themeMap) {
        StringBuffer builder = new StringBuffer();
        Iterator<Map.Entry<String, String>> itr = themeMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, String> entry = itr.next();
            builder.append(entry.getKey()).append(":").append(entry.getValue());
            if (!itr.hasNext()) continue;
            builder.append("::");
        }
        return builder.toString();
    }

    private Map<String, String> stringToThemeMap(String themesString) {
        String[] themeIds;
        HashMap<String, String> themeMap = new HashMap<String, String>();
        for (String ele : themeIds = themesString.split("::")) {
            String[] strs = ele.split(":");
            themeMap.put(strs[0], strs[1]);
        }
        return themeMap;
    }

    public ExoWindowID getExoWindowID() {
        return this.exoWindowId_;
    }

    public Map<String, String[]> getRenderParametersMap() {
        return this.renderParametersMap_;
    }

    public void setRenderParametersMap(Map<String, String[]> map) {
        this.renderParametersMap_ = map;
    }

    public PortletMode getCurrentPortletMode() {
        return this.currentPortletMode_;
    }

    public void setCurrentPortletMode(PortletMode mode) {
        this.currentPortletMode_ = mode;
    }

    public WindowState getCurrentWindowState() {
        return this.currentWindowState_;
    }

    public void setCurrentWindowState(WindowState state) {
        this.currentWindowState_ = state;
    }

    public List getSupportedProcessingEvents() {
        return this.supportedProcessingEvents_;
    }

    public void setSupportedProcessingEvents(List supportedProcessingEvents) {
        this.supportedProcessingEvents_ = supportedProcessingEvents;
    }

    public List getSupportedPublicRenderParameters() {
        return this.supportedPublicParams_;
    }

    public void setSupportedPublicRenderParameters(List supportedPublicRenderParameters) {
        this.supportedPublicParams_ = supportedPublicRenderParameters;
    }

    public List<String> getSupportModes() {
        if (this.supportModes_ != null) {
            return this.supportModes_;
        }
        PortletContainerService portletContainer = (PortletContainerService)this.getApplicationComponent(PortletContainerService.class);
        String portletId = this.exoWindowId_.getPortletApplicationName() + "/" + this.exoWindowId_.getPortletName();
        PortletData portletData = (PortletData)portletContainer.getAllPortletMetaData().get(portletId);
        if (portletData == null) {
            return null;
        }
        List sukepportsList = portletData.getSupports();
        ArrayList<String> supportModes = new ArrayList<String>();
        for (int i = 0; i < sukepportsList.size(); ++i) {
            Supports supports = (Supports)sukepportsList.get(i);
            String mimeType = supports.getMimeType();
            if (!"text/html".equals(mimeType)) continue;
            List modes = supports.getPortletMode();
            for (int j = 0; j < modes.size(); ++j) {
                String mode = (String)modes.get(j);
                if ("config".equals(mode = mode.toLowerCase())) {
                    supportModes.add(mode);
                    continue;
                }
                supportModes.add(mode);
            }
            break;
        }
        if (supportModes.size() > 0) {
            supportModes.remove("view");
        }
        this.setSupportModes(supportModes);
        return supportModes;
    }

    public void setSupportModes(List<String> supportModes) {
        this.supportModes_ = supportModes;
    }

    public boolean supportsProcessingEvent(QName name) {
        if (this.supportedProcessingEvents_ == null) {
            PortletContainerService portletContainer = (PortletContainerService)this.getApplicationComponent(PortletContainerService.class);
            String portletId = this.exoWindowId_.getPortletApplicationName() + "/" + this.exoWindowId_.getPortletName();
            PortletData portletData = (PortletData)portletContainer.getAllPortletMetaData().get(portletId);
            this.supportedProcessingEvents_ = portletData.getSupportedProcessingEvent();
        }
        if (this.supportedProcessingEvents_ == null) {
            return false;
        }
        for (QName eventName : this.supportedProcessingEvents_) {
            if (!eventName.equals(name)) continue;
            log.info((Object)("The Portlet " + this.windowId + " supports the event : " + name));
            return true;
        }
        return false;
    }

    public boolean supportsPublicParam(String supportedPublicParam) {
        if (this.supportedPublicParams_ == null) {
            PortletContainerService portletContainer = (PortletContainerService)this.getApplicationComponent(PortletContainerService.class);
            String portletId = this.exoWindowId_.getPortletApplicationName() + "/" + this.exoWindowId_.getPortletName();
            PortletData portletData = (PortletData)portletContainer.getAllPortletMetaData().get(portletId);
            this.supportedPublicParams_ = portletData.getSupportedPublicRenderParameter();
        }
        if (this.supportedPublicParams_ == null) {
            return false;
        }
        for (String publicParam : this.supportedPublicParams_) {
            if (!publicParam.equals(supportedPublicParam)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("The Portlet " + this.windowId + " supports the public render parameter : " + supportedPublicParam));
            }
            return true;
        }
        return false;
    }

    public List<String> getPublicRenderParamNames() {
        UIPortal uiPortal = Util.getUIPortal();
        Map<String, String[]> publicParams = uiPortal.getPublicParameters();
        ArrayList<String> publicParamsSupportedByPortlet = new ArrayList<String>();
        if (publicParams != null) {
            Set<String> keys = publicParams.keySet();
            for (String key : keys) {
                if (!this.supportsPublicParam(key)) continue;
                publicParamsSupportedByPortlet.add(key);
            }
            return publicParamsSupportedByPortlet;
        }
        return new ArrayList<String>();
    }

    public Map<String, String[]> getPublicParameters() {
        HashMap<String, String[]> publicParamsMap = new HashMap<String, String[]>();
        UIPortal uiPortal = Util.getUIPortal();
        Map<String, String[]> publicParams = uiPortal.getPublicParameters();
        Set<String> allPublicParamsNames = publicParams.keySet();
        List<String> supportedPublicParamNames = this.getPublicRenderParamNames();
        for (String oneOfAllParams : allPublicParamsNames) {
            if (!supportedPublicParamNames.contains(oneOfAllParams)) continue;
            publicParamsMap.put(oneOfAllParams, publicParams.get(oneOfAllParams));
        }
        return publicParamsMap;
    }
}

