/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNodeIterator;
import org.exoplatform.services.log.ExoLogger;

class DocOrderNodeCachedIteratorImpl
implements ScoreNodeIterator {
    private static Log log = ExoLogger.getLogger((String)"jcr.DocOrderNodeDataIteratorImpl");
    private boolean ordered = false;
    protected String[] identifiers;
    protected Float[] scores;
    protected final SessionDataManager dataManager;
    protected int ipos = -1;
    protected int invalid = 0;
    private NodeImpl inext;
    private final boolean cached;
    private final Map<String, NodeImpl> lcache = new HashMap<String, NodeImpl>();

    DocOrderNodeCachedIteratorImpl(SessionDataManager dataManager, String[] identifiers, Float[] scores) {
        this.dataManager = dataManager;
        this.identifiers = identifiers;
        this.scores = scores;
        this.cached = true;
    }

    DocOrderNodeCachedIteratorImpl(SessionDataManager dataManager, String[] identifiers, Float[] scores, boolean cached) {
        this.dataManager = dataManager;
        this.identifiers = identifiers;
        this.scores = scores;
        this.cached = cached;
    }

    public Object next() {
        return this.nextNodeImpl();
    }

    public Node nextNode() {
        return this.nextNodeImpl();
    }

    public NodeImpl nextNodeImpl() {
        this.initOrderedIterator();
        if (this.inext == null) {
            throw new NoSuchElementException();
        }
        NodeImpl n = this.inext;
        this.fetchNext();
        return n;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public void skip(long skipNum) {
        this.initOrderedIterator();
        if (skipNum < 0L) {
            throw new IllegalArgumentException("skipNum must not be negative");
        }
        if ((long)this.ipos + skipNum > (long)this.identifiers.length) {
            throw new NoSuchElementException();
        }
        if (skipNum > 0L) {
            this.ipos = (int)((long)this.ipos + (skipNum - 1L));
            this.fetchNext();
        }
    }

    public long getSize() {
        return this.identifiers.length - this.invalid;
    }

    public long getPosition() {
        this.initOrderedIterator();
        return this.ipos - this.invalid;
    }

    public boolean hasNext() {
        this.initOrderedIterator();
        return this.inext != null;
    }

    public float getScore() {
        this.initOrderedIterator();
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.scores[this.ipos].floatValue();
    }

    private void initOrderedIterator() {
        if (this.ordered) {
            return;
        }
        long time = System.currentTimeMillis();
        ScoreNode[] nodes = new ScoreNode[this.identifiers.length];
        for (int i = 0; i < this.identifiers.length; ++i) {
            nodes[i] = new ScoreNode(this.identifiers[i], this.scores[i]);
        }
        final ArrayList invalidIdentifiers = new ArrayList(2);
        do {
            if (invalidIdentifiers.size() > 0) {
                ScoreNode[] tmp = new ScoreNode[nodes.length - invalidIdentifiers.size()];
                int newIdx = 0;
                for (int i = 0; i < nodes.length; ++i) {
                    if (invalidIdentifiers.contains(nodes[i].identifier)) continue;
                    tmp[newIdx++] = nodes[i];
                }
                nodes = tmp;
                invalidIdentifiers.clear();
            }
            try {
                Arrays.sort(nodes, new Comparator<ScoreNode>(){

                    private NodeImpl getNode(String id) throws RepositoryException {
                        NodeImpl node = (NodeImpl)DocOrderNodeCachedIteratorImpl.this.lcache.get(id);
                        if (node == null) {
                            node = (NodeImpl)DocOrderNodeCachedIteratorImpl.this.dataManager.getItemByIdentifier(id, false);
                            if (node != null) {
                                DocOrderNodeCachedIteratorImpl.this.lcache.put(id, node);
                            }
                            return node;
                        }
                        return node;
                    }

                    @Override
                    public int compare(ScoreNode n1, ScoreNode n2) {
                        try {
                            int commonDepth;
                            NodeImpl node2;
                            NodeImpl node1;
                            try {
                                node1 = this.getNode(n1.identifier);
                                if (node1 == null) {
                                    throw new RepositoryException("Node not found for " + n1.identifier);
                                }
                            }
                            catch (RepositoryException e) {
                                invalidIdentifiers.add(n1.identifier);
                                throw new SortFailedException();
                            }
                            try {
                                node2 = this.getNode(n2.identifier);
                                if (node2 == null) {
                                    throw new RepositoryException("Node not found for " + n2.identifier);
                                }
                            }
                            catch (RepositoryException e) {
                                invalidIdentifiers.add(n2.identifier);
                                throw new SortFailedException();
                            }
                            NodeData ndata1 = (NodeData)node1.getData();
                            NodeData ndata2 = (NodeData)node2.getData();
                            QPath path1 = ndata1.getQPath();
                            QPath path2 = ndata2.getQPath();
                            QPathEntry[] pentries1 = path1.getEntries();
                            QPathEntry[] pentries2 = path2.getEntries();
                            for (commonDepth = 0; pentries1.length > commonDepth && pentries2.length > commonDepth && pentries1[commonDepth].equals(pentries2[commonDepth]); ++commonDepth) {
                            }
                            if (pentries1.length - 1 == --commonDepth) {
                                return -1;
                            }
                            if (pentries2.length - 1 == commonDepth) {
                                return 1;
                            }
                            return ndata1.getOrderNumber() - ndata2.getOrderNumber();
                        }
                        catch (SortFailedException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            log.error((Object)("Exception while sorting nodes in document order: " + e.toString()), (Throwable)e);
                            invalidIdentifiers.add(n1.identifier);
                            invalidIdentifiers.add(n2.identifier);
                            throw new SortFailedException();
                        }
                    }
                });
            }
            catch (SortFailedException e) {
                // empty catch block
            }
        } while (invalidIdentifiers.size() > 0);
        if (this.identifiers.length != nodes.length) {
            this.identifiers = new String[nodes.length];
            this.scores = new Float[nodes.length];
        }
        for (int i = 0; i < nodes.length; ++i) {
            this.identifiers[i] = nodes[i].identifier;
            this.scores[i] = nodes[i].score;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("" + this.identifiers.length + " node(s) ordered in " + (System.currentTimeMillis() - time) + " ms"));
        }
        this.fetchNext();
        this.ordered = true;
    }

    protected void fetchNext() {
        this.inext = null;
        while (this.inext == null && this.ipos + 1 < this.identifiers.length) {
            try {
                this.inext = this.getNode(this.identifiers[this.ipos + 1]);
            }
            catch (RepositoryException e) {
                log.warn((Object)("Exception retrieving Node with UUID: " + this.identifiers[this.ipos + 1] + ": " + (Object)((Object)e)), (Throwable)e);
                ++this.invalid;
            }
            ++this.ipos;
        }
        if (this.identifiers.length == 0) {
            this.ipos = this.identifiers.length;
        } else if (this.ipos + 1 == this.identifiers.length && this.inext == null) {
            ++this.ipos;
        }
    }

    private NodeImpl getNode(String id) throws RepositoryException {
        if (this.cached) {
            NodeImpl node = this.lcache.get(id);
            if (node == null) {
                node = (NodeImpl)this.dataManager.getItemByIdentifier(id, false);
                if (node != null) {
                    this.lcache.put(id, node);
                }
                return node;
            }
            return node;
        }
        return (NodeImpl)this.dataManager.getItemByIdentifier(id, false);
    }

    private static final class ScoreNode {
        final String identifier;
        final Float score;

        ScoreNode(String identifier, Float score) {
            this.identifier = identifier;
            this.score = score;
        }
    }

    private static final class SortFailedException
    extends RuntimeException {
        private SortFailedException() {
        }
    }
}

