/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNodeIterator;

class RowIteratorImpl
implements RowIterator {
    private final ScoreNodeIterator nodes;
    private final InternalQName[] properties;
    private final SessionImpl session;

    RowIteratorImpl(ScoreNodeIterator nodes, InternalQName[] properties, SessionImpl session) {
        this.nodes = nodes;
        this.properties = properties;
        this.session = session;
    }

    public Row nextRow() throws NoSuchElementException {
        return new RowImpl(this.nodes.getScore(), this.nodes.nextNodeImpl());
    }

    public void skip(long skipNum) throws NoSuchElementException {
        this.nodes.skip(skipNum);
    }

    public long getSize() {
        return this.nodes.getSize();
    }

    public long getPosition() {
        return this.nodes.getPosition();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public boolean hasNext() {
        return this.nodes.hasNext();
    }

    public Object next() throws NoSuchElementException {
        return this.nextRow();
    }

    class RowImpl
    implements Row {
        private final float score;
        private final NodeImpl node;
        private Value[] values;
        private Set propertySet;

        RowImpl(float score, NodeImpl node) {
            this.score = score;
            this.node = node;
        }

        public Value[] getValues() throws RepositoryException {
            if (this.values == null) {
                Value[] tmp = new Value[RowIteratorImpl.this.properties.length];
                for (int i = 0; i < RowIteratorImpl.this.properties.length; ++i) {
                    String propertyName = RowIteratorImpl.this.session.getLocationFactory().createJCRName(RowIteratorImpl.this.properties[i]).getAsString();
                    if (this.node.hasProperty(propertyName)) {
                        PropertyImpl prop = (PropertyImpl)this.node.getProperty(propertyName);
                        if (!prop.isMultiValued()) {
                            if (prop.getDefinition().getRequiredType() == 0) {
                                tmp[i] = RowIteratorImpl.this.session.getValueFactory().createValue(prop.getString());
                                continue;
                            }
                            tmp[i] = prop.getValue();
                            continue;
                        }
                        tmp[i] = null;
                        continue;
                    }
                    tmp[i] = Constants.JCR_PATH.equals((Object)RowIteratorImpl.this.properties[i]) ? RowIteratorImpl.this.session.getValueFactory().createValue(this.node.getPath(), 8) : (Constants.JCR_SCORE.equals((Object)RowIteratorImpl.this.properties[i]) ? RowIteratorImpl.this.session.getValueFactory().createValue((long)(this.score * 1000.0f)) : null);
                }
                this.values = tmp;
            }
            Value[] ret = new Value[this.values.length];
            System.arraycopy(this.values, 0, ret, 0, this.values.length);
            return ret;
        }

        public Value getValue(String propertyName) throws ItemNotFoundException, RepositoryException {
            InternalQName prop = RowIteratorImpl.this.session.getLocationFactory().parseJCRName(propertyName).getInternalName();
            boolean exists = false;
            for (int i = 0; i < RowIteratorImpl.this.properties.length; ++i) {
                if (!prop.equals((Object)RowIteratorImpl.this.properties[i])) continue;
                exists = true;
                break;
            }
            if (!exists) {
                throw new ItemNotFoundException(propertyName);
            }
            if (this.node.hasProperty(propertyName)) {
                Property p = this.node.getProperty(propertyName);
                if (p.getDefinition().getRequiredType() == 0) {
                    return RowIteratorImpl.this.session.getValueFactory().createValue(p.getString());
                }
                return p.getValue();
            }
            if ("jcr:path".equals(propertyName)) {
                return RowIteratorImpl.this.session.getValueFactory().createValue(this.node.getPath(), 8);
            }
            if ("jcr:score".equals(propertyName)) {
                return RowIteratorImpl.this.session.getValueFactory().createValue((long)(this.score * 1000.0f));
            }
            return null;
        }
    }
}

