/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.sql;

import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.query.InvalidQueryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.query.AndQueryNode;
import org.exoplatform.services.jcr.impl.core.query.LocationStepQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NAryQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NodeTypeQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NotQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrderQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PathQueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryRootNode;
import org.exoplatform.services.jcr.impl.core.query.RelationQueryNode;
import org.exoplatform.services.jcr.impl.core.query.TextsearchQueryNode;
import org.exoplatform.services.jcr.impl.core.query.sql.ASTAndExpression;
import org.exoplatform.services.jcr.impl.core.query.sql.ASTAscendingOrderSpec;
import org.exoplatform.services.jcr.impl.core.query.sql.ASTBracketExpression;
import org.exoplatform.services.jcr.impl.core.query.sql.ASTContainsExpression;
import org.exoplatform.services.jcr.impl.core.query.sql.ASTDescendingOrderSpec;
import org.exoplatform.services.jcr.impl.core.query.sql.ASTFromClause;
import org.exoplatform.services.jcr.impl.core.query.sql.ASTIdentifier;
import org.exoplatform.services.jcr.impl.core.query.sql.ASTLiteral;
import org.exoplatform.services.jcr.impl.core.query.sql.ASTNotExpression;
import org.exoplatform.services.jcr.impl.core.query.sql.ASTOrExpression;
import org.exoplatform.services.jcr.impl.core.query.sql.ASTOrderByClause;
import org.exoplatform.services.jcr.impl.core.query.sql.ASTOrderSpec;
import org.exoplatform.services.jcr.impl.core.query.sql.ASTPredicate;
import org.exoplatform.services.jcr.impl.core.query.sql.ASTQuery;
import org.exoplatform.services.jcr.impl.core.query.sql.ASTSelectList;
import org.exoplatform.services.jcr.impl.core.query.sql.ASTWhereClause;
import org.exoplatform.services.jcr.impl.core.query.sql.DefaultParserVisitor;
import org.exoplatform.services.jcr.impl.core.query.sql.JCRSQLParser;
import org.exoplatform.services.jcr.impl.core.query.sql.JCRSQLParserVisitor;
import org.exoplatform.services.jcr.impl.core.query.sql.ParseException;
import org.exoplatform.services.jcr.impl.core.query.sql.QueryFormat;
import org.exoplatform.services.jcr.impl.core.query.sql.SimpleNode;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.log.ExoLogger;

public class JCRSQLQueryBuilder
implements JCRSQLParserVisitor {
    private static Log log = ExoLogger.getLogger((String)"jcr.JCRSQLQueryBuilder");
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static Map parsers = new WeakHashMap();
    private final ASTQuery stmt;
    private QueryRootNode root;
    private LocationFactory locationFactory;
    private final AndQueryNode constraintNode = new AndQueryNode(null);
    private final List pathConstraints = new ArrayList();

    private JCRSQLQueryBuilder(ASTQuery statement, LocationFactory locationFactory) {
        this.stmt = statement;
        this.locationFactory = locationFactory;
    }

    public static QueryRootNode createQuery(String statement, LocationFactory locationFactory) throws InvalidQueryException {
        try {
            JCRSQLParser parser = new JCRSQLParser(new StringReader(statement));
            parser.setLocationfactory(locationFactory);
            JCRSQLQueryBuilder builder = new JCRSQLQueryBuilder(parser.Query(), locationFactory);
            return builder.getRootNode();
        }
        catch (ParseException e) {
            throw new InvalidQueryException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidQueryException(e.getMessage());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new InvalidQueryException(t.getMessage());
        }
    }

    public static String toString(QueryRootNode root, LocationFactory locationFactory) throws InvalidQueryException {
        return QueryFormat.toString(root, locationFactory);
    }

    private QueryRootNode getRootNode() {
        if (this.root == null) {
            this.stmt.jjtAccept(this, null);
        }
        return this.root;
    }

    public Object visit(SimpleNode node, Object data) {
        return data;
    }

    public Object visit(ASTQuery node, Object data) {
        this.root = new QueryRootNode();
        this.root.setLocationNode(new PathQueryNode(this.root));
        node.childrenAccept(this, this.root);
        PathQueryNode pathNode = this.root.getLocationNode();
        pathNode.setAbsolute(true);
        if (this.pathConstraints.size() == 0) {
            pathNode.addPathStep(new LocationStepQueryNode(pathNode, null, true));
        } else {
            MergingPathQueryNode path;
            try {
                while (this.pathConstraints.size() > 1) {
                    path = null;
                    Iterator it = this.pathConstraints.iterator();
                    while (it.hasNext() && !(path = (MergingPathQueryNode)it.next()).needsMerge()) {
                        path = null;
                    }
                    if (path == null) {
                        throw new IllegalArgumentException("Invalid combination of jcr:path clauses");
                    }
                    this.pathConstraints.remove(path);
                    MergingPathQueryNode[] paths = this.pathConstraints.toArray(new MergingPathQueryNode[this.pathConstraints.size()]);
                    paths = path.doMerge(paths);
                    this.pathConstraints.clear();
                    this.pathConstraints.addAll(Arrays.asList(paths));
                }
            }
            catch (NoSuchElementException e) {
                throw new IllegalArgumentException("Invalid combination of jcr:path clauses");
            }
            path = (MergingPathQueryNode)this.pathConstraints.get(0);
            LocationStepQueryNode[] steps = path.getPathSteps();
            for (int i = 0; i < steps.length; ++i) {
                LocationStepQueryNode step = new LocationStepQueryNode(pathNode, steps[i].getNameTest(), steps[i].getIncludeDescendants());
                step.setIndex(steps[i].getIndex());
                pathNode.addPathStep(step);
            }
        }
        if (this.constraintNode.getNumOperands() > 0) {
            LocationStepQueryNode[] steps = pathNode.getPathSteps();
            steps[steps.length - 1].addPredicate(this.constraintNode);
        }
        return this.root;
    }

    public Object visit(ASTSelectList node, Object data) {
        final QueryRootNode root = (QueryRootNode)data;
        node.childrenAccept(new DefaultParserVisitor(){

            public Object visit(ASTIdentifier node, Object data) {
                root.addSelectProperty(node.getName());
                return data;
            }
        }, root);
        return data;
    }

    public Object visit(ASTFromClause node, Object data) {
        QueryRootNode root = (QueryRootNode)data;
        return node.childrenAccept(new DefaultParserVisitor(){

            public Object visit(ASTIdentifier node, Object data) {
                if (!node.getName().equals((Object)Constants.NT_BASE)) {
                    NodeTypeQueryNode nodeType = new NodeTypeQueryNode(JCRSQLQueryBuilder.this.constraintNode, node.getName());
                    JCRSQLQueryBuilder.this.constraintNode.addOperand(nodeType);
                }
                return data;
            }
        }, root);
    }

    public Object visit(ASTWhereClause node, Object data) {
        return node.childrenAccept(this, this.constraintNode);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object visit(ASTPredicate node, Object data) {
        void var5_20;
        NAryQueryNode parent = (NAryQueryNode)data;
        int type = node.getOperationType();
        try {
            final InternalQName[] tmp = new InternalQName[2];
            final ASTLiteral[] value = new ASTLiteral[1];
            node.childrenAccept(new DefaultParserVisitor(){

                public Object visit(ASTIdentifier node, Object data) {
                    if (tmp[0] == null) {
                        tmp[0] = node.getName();
                    } else if (tmp[1] == null) {
                        tmp[1] = node.getName();
                    }
                    return data;
                }

                public Object visit(ASTLiteral node, Object data) {
                    value[0] = node;
                    return data;
                }
            }, data);
            InternalQName identifier = tmp[0];
            if (identifier.equals((Object)Constants.JCR_PATH)) {
                if (tmp[1] != null) return data;
                this.createPathQuery(value[0].getValue(), parent.getType());
                return data;
            }
            if (type == 24) {
                AndQueryNode between = new AndQueryNode(parent);
                RelationQueryNode rel = this.createRelationQueryNode(between, identifier, 20, (ASTLiteral)node.children[1]);
                between.addOperand(rel);
                rel = this.createRelationQueryNode(between, identifier, 22, (ASTLiteral)node.children[2]);
                between.addOperand(rel);
                AndQueryNode andQueryNode = between;
            } else if (type == 20 || type == 18 || type == 22 || type == 16 || type == 14 || type == 12) {
                RelationQueryNode relationQueryNode = this.createRelationQueryNode(parent, identifier, type, value[0]);
            } else if (type == 23) {
                ASTLiteral pattern = value[0];
                if (node.getEscapeString() != null) {
                    if (node.getEscapeString().length() != 1) throw new IllegalArgumentException("ESCAPE string value must have length 1: '" + node.getEscapeString() + "'");
                    pattern.setValue(JCRSQLQueryBuilder.translateEscaping(pattern.getValue(), node.getEscapeString().charAt(0), '\\'));
                } else {
                    pattern.setValue(pattern.getValue().replaceAll("\\\\", "\\\\\\\\"));
                }
                RelationQueryNode relationQueryNode = this.createRelationQueryNode(parent, identifier, type, pattern);
            } else if (type == 25) {
                OrQueryNode in = new OrQueryNode(parent);
                for (int i = 1; i < node.children.length; ++i) {
                    RelationQueryNode rel = this.createRelationQueryNode(in, identifier, 11, (ASTLiteral)node.children[i]);
                    in.addOperand(rel);
                }
                OrQueryNode orQueryNode = in;
            } else {
                if (type != 26 && type != 27) throw new IllegalArgumentException("Unknown operation type: " + type);
                ASTLiteral star = new ASTLiteral(11);
                star.setType(3);
                star.setValue("%");
                RelationQueryNode relationQueryNode = this.createRelationQueryNode(parent, identifier, type, star);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Too few arguments in predicate");
        }
        if (var5_20 == null) return data;
        parent.addOperand((QueryNode)var5_20);
        return data;
    }

    public Object visit(ASTOrExpression node, Object data) {
        NAryQueryNode parent = (NAryQueryNode)data;
        OrQueryNode orQuery = new OrQueryNode(parent);
        node.childrenAccept(this, orQuery);
        if (orQuery.getNumOperands() > 0) {
            parent.addOperand(orQuery);
        }
        return parent;
    }

    public Object visit(ASTAndExpression node, Object data) {
        NAryQueryNode parent = (NAryQueryNode)data;
        AndQueryNode andQuery = new AndQueryNode(parent);
        node.childrenAccept(this, andQuery);
        parent.addOperand(andQuery);
        return parent;
    }

    public Object visit(ASTNotExpression node, Object data) {
        NAryQueryNode parent = (NAryQueryNode)data;
        NotQueryNode notQuery = new NotQueryNode(parent);
        node.childrenAccept(this, notQuery);
        parent.addOperand(notQuery);
        return parent;
    }

    public Object visit(ASTBracketExpression node, Object data) {
        return node.childrenAccept(this, data);
    }

    public Object visit(ASTLiteral node, Object data) {
        return data;
    }

    public Object visit(ASTIdentifier node, Object data) {
        return data;
    }

    public Object visit(ASTOrderByClause node, Object data) {
        QueryRootNode root = (QueryRootNode)data;
        OrderQueryNode order = new OrderQueryNode(root);
        root.setOrderNode(order);
        node.childrenAccept(this, order);
        return root;
    }

    public Object visit(ASTOrderSpec node, Object data) {
        OrderQueryNode order = (OrderQueryNode)data;
        final InternalQName[] identifier = new InternalQName[1];
        node.childrenAccept(new DefaultParserVisitor(){

            public Object visit(ASTIdentifier node, Object data) {
                identifier[0] = node.getName();
                return data;
            }
        }, data);
        OrderQueryNode.OrderSpec spec = new OrderQueryNode.OrderSpec(identifier[0], true);
        order.addOrderSpec(spec);
        node.childrenAccept(this, spec);
        return data;
    }

    public Object visit(ASTAscendingOrderSpec node, Object data) {
        return data;
    }

    public Object visit(ASTDescendingOrderSpec node, Object data) {
        OrderQueryNode.OrderSpec spec = (OrderQueryNode.OrderSpec)data;
        spec.setAscending(false);
        return data;
    }

    public Object visit(ASTContainsExpression node, Object data) {
        NAryQueryNode parent = (NAryQueryNode)data;
        parent.addOperand(new TextsearchQueryNode(parent, node.getQuery(), node.getPropertyName()));
        return parent;
    }

    private RelationQueryNode createRelationQueryNode(QueryNode parent, InternalQName propertyName, int operationType, ASTLiteral literal) throws IllegalArgumentException {
        RelationQueryNode node;
        block10: {
            String stringValue = literal.getValue();
            node = null;
            try {
                if (literal.getType() == 4) {
                    SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
                    Date date = format.parse(stringValue);
                    node = new RelationQueryNode(parent, propertyName, date, operationType);
                    break block10;
                }
                if (literal.getType() == 2) {
                    double d = Double.parseDouble(stringValue);
                    node = new RelationQueryNode(parent, propertyName, d, operationType);
                    break block10;
                }
                if (literal.getType() == 1) {
                    long l = Long.parseLong(stringValue);
                    node = new RelationQueryNode(parent, propertyName, l, operationType);
                    break block10;
                }
                if (literal.getType() == 3) {
                    node = new RelationQueryNode(parent, propertyName, stringValue, operationType);
                    break block10;
                }
                if (literal.getType() != 5) break block10;
                try {
                    Calendar c = JCRDateFormat.parse(stringValue);
                    node = new RelationQueryNode(parent, propertyName, c.getTime(), operationType);
                }
                catch (ValueFormatException e) {
                    throw new IllegalArgumentException("Can not parse TIMESTAMP " + stringValue + ". " + e.getMessage(), e);
                }
            }
            catch (java.text.ParseException e) {
                throw new IllegalArgumentException(e.toString());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e.toString());
            }
        }
        if (node == null) {
            throw new IllegalArgumentException("Unknown type for literal: " + literal.getType());
        }
        return node;
    }

    private void createPathQuery(String path, int operation) {
        MergingPathQueryNode pathNode = new MergingPathQueryNode(operation);
        pathNode.setAbsolute(true);
        if (path.equals("/")) {
            pathNode.addPathStep(new LocationStepQueryNode(pathNode, new InternalQName("", ""), false));
            this.pathConstraints.add(pathNode);
            return;
        }
        String[] names = path.split("/");
        for (int i = 0; i < names.length; ++i) {
            String name;
            if (names[i].length() == 0) {
                if (i == 0) {
                    pathNode.addPathStep(new LocationStepQueryNode(pathNode, new InternalQName("", ""), false));
                    continue;
                }
                pathNode.addPathStep(new LocationStepQueryNode(pathNode, new InternalQName("", ""), false));
                continue;
            }
            int idx = names[i].indexOf(91);
            int index = -2147483647;
            if (idx > -1) {
                name = names[i].substring(0, idx);
                String suffix = names[i].substring(idx);
                String indexStr = suffix.substring(1, suffix.length() - 1);
                if (indexStr.equals("%")) {
                    index = -2147483647;
                } else {
                    try {
                        index = Integer.parseInt(indexStr);
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Unable to parse index for path element: " + names[i]));
                    }
                }
                if (name.equals("%")) {
                    name = null;
                }
            } else {
                name = names[i];
                if (name.equals("%")) {
                    name = null;
                } else {
                    index = 1;
                }
            }
            InternalQName qName = null;
            if (name != null) {
                try {
                    qName = this.locationFactory.parseJCRName(name).getInternalName();
                }
                catch (RepositoryException e) {
                    throw new IllegalArgumentException("Illegal name: " + name);
                }
            }
            boolean descendant = name == null;
            LocationStepQueryNode step = new LocationStepQueryNode(pathNode, qName, descendant);
            if (index > 0) {
                step.setIndex(index);
            }
            pathNode.addPathStep(step);
        }
        this.pathConstraints.add(pathNode);
    }

    private static String translateEscaping(String pattern, char from, char to) {
        if (from == to || pattern.indexOf(from) < 0 && pattern.indexOf(to) < 0) {
            return pattern;
        }
        StringBuffer translated = new StringBuffer(pattern.length());
        boolean escaped = false;
        for (int i = 0; i < pattern.length(); ++i) {
            if (pattern.charAt(i) == from) {
                if (escaped) {
                    translated.append(from);
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (pattern.charAt(i) == to) {
                if (escaped) {
                    translated.append(to).append(to);
                    escaped = false;
                    continue;
                }
                translated.append(to).append(to);
                continue;
            }
            if (escaped) {
                translated.append(to);
                escaped = false;
            }
            translated.append(pattern.charAt(i));
        }
        return translated.toString();
    }

    private static class MergingPathQueryNode
    extends PathQueryNode {
        private int operation;

        MergingPathQueryNode(int operation) {
            super(null);
            if (operation != 8 && operation != 7 && operation != 9) {
                throw new IllegalArgumentException("operation");
            }
            this.operation = operation;
        }

        MergingPathQueryNode[] doMerge(MergingPathQueryNode[] nodes) {
            if (this.operation == 8) {
                return this.doOrMerge(nodes);
            }
            return this.doAndMerge(nodes);
        }

        private MergingPathQueryNode[] doAndMerge(MergingPathQueryNode[] nodes) {
            if (this.operation == 7) {
                MergingPathQueryNode n = null;
                for (int i = 0; i < nodes.length; ++i) {
                    if (nodes[i].operation != 9) continue;
                    n = nodes[i];
                    nodes[i] = this;
                }
                if (n == null) {
                    throw new NoSuchElementException("Merging not possible with any node");
                }
                return super.doAndMerge(nodes);
            }
            if (this.operands.size() < 3) {
                throw new NoSuchElementException("Merging not possible");
            }
            int size = this.operands.size();
            LocationStepQueryNode n1 = (LocationStepQueryNode)this.operands.get(size - 1);
            LocationStepQueryNode n2 = (LocationStepQueryNode)this.operands.get(size - 2);
            if (n1.getNameTest() != null || n2.getNameTest() != null || !n1.getIncludeDescendants() || !n2.getIncludeDescendants()) {
                throw new NoSuchElementException("Merging not possible");
            }
            MergingPathQueryNode matchedNode = null;
            for (int i = 0; i < nodes.length; ++i) {
                boolean bl;
                if (nodes[i].operands.size() != this.operands.size() - 1) continue;
                boolean match = true;
                for (int j = 0; j < this.operands.size() - 1 && match; match &= bl, ++j) {
                    LocationStepQueryNode step = (LocationStepQueryNode)this.operands.get(j);
                    LocationStepQueryNode other = (LocationStepQueryNode)nodes[i].operands.get(j);
                    if (step.getNameTest() == null) {
                        if (other.getNameTest() == null) {
                            bl = true;
                            continue;
                        }
                        bl = false;
                        continue;
                    }
                    bl = step.getNameTest().equals((Object)other.getNameTest());
                }
                if (!match) continue;
                matchedNode = nodes[i];
                break;
            }
            if (matchedNode == null) {
                throw new NoSuchElementException("Merging not possible with any node");
            }
            ((LocationStepQueryNode)matchedNode.operands.get(matchedNode.operands.size() - 1)).setIncludeDescendants(false);
            return nodes;
        }

        private MergingPathQueryNode[] doOrMerge(MergingPathQueryNode[] nodes) {
            MergingPathQueryNode compacted = new MergingPathQueryNode(8);
            Iterator it = this.operands.iterator();
            while (it.hasNext()) {
                LocationStepQueryNode step = (LocationStepQueryNode)it.next();
                if (step.getIncludeDescendants() && step.getNameTest() == null) {
                    if (it.hasNext()) {
                        LocationStepQueryNode next = (LocationStepQueryNode)it.next();
                        next.setIncludeDescendants(true);
                        compacted.addPathStep(next);
                        continue;
                    }
                    compacted.addPathStep(step);
                    continue;
                }
                compacted.addPathStep(step);
            }
            MergingPathQueryNode matchedNode = null;
            for (int i = 0; i < nodes.length; ++i) {
                boolean match;
                boolean bl;
                if (nodes[i].operands.size() != compacted.operands.size()) continue;
                Iterator compactedSteps = compacted.operands.iterator();
                Iterator otherSteps = nodes[i].operands.iterator();
                for (match = true; match && compactedSteps.hasNext(); match &= bl) {
                    LocationStepQueryNode n1 = (LocationStepQueryNode)compactedSteps.next();
                    LocationStepQueryNode n2 = (LocationStepQueryNode)otherSteps.next();
                    if (n1.getNameTest() == null) {
                        if (n2.getNameTest() == null) {
                            bl = true;
                            continue;
                        }
                        bl = false;
                        continue;
                    }
                    bl = n1.getNameTest().equals((Object)n2.getNameTest());
                }
                if (!match) continue;
                matchedNode = nodes[i];
                break;
            }
            if (matchedNode == null) {
                throw new NoSuchElementException("Merging not possible with any node.");
            }
            ArrayList<MergingPathQueryNode> mergedList = new ArrayList<MergingPathQueryNode>(Arrays.asList(nodes));
            mergedList.remove(matchedNode);
            mergedList.add(compacted);
            return mergedList.toArray(new MergingPathQueryNode[mergedList.size()]);
        }

        boolean needsMerge() {
            for (LocationStepQueryNode step : this.operands) {
                if (!step.getIncludeDescendants() || step.getNameTest() != null) continue;
                return true;
            }
            return false;
        }
    }
}

