/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.importing;

import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.xml.XmlSaveType;
import org.exoplatform.services.jcr.impl.xml.importing.SystemViewImporter;
import org.exoplatform.services.jcr.impl.xml.importing.dataflow.ImportNodeData;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceContentImporter
extends SystemViewImporter {
    private final Log log = ExoLogger.getLogger((String)"jcr.WorkspaceContentImporter");
    private boolean isFirstElementChecked = false;

    public WorkspaceContentImporter(NodeImpl parent, int uuidBehavior, XmlSaveType saveType, InvocationContext context) {
        super(parent, uuidBehavior, saveType, context);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String name, Map<String, String> atts) throws RepositoryException {
        InternalQName elementName = this.locationFactory.parseJCRName(name).getInternalName();
        if (Constants.SV_NODE_NAME.equals((Object)elementName)) {
            String svName = this.getAttribute(atts, Constants.SV_NAME_NAME);
            if (svName == null) {
                throw new RepositoryException("Missing mandatory sv:name attribute of element sv:node");
            }
            String svId = this.getAttribute(atts, Constants.EXO_ID_NAME);
            if (svId == null) {
                throw new RepositoryException("Missing mandatory exo:id attribute of element sv:node");
            }
            ImportNodeData newNodeData = null;
            InternalQName currentNodeName = null;
            int nodeIndex = 1;
            NodeData parentData = (NodeData)this.tree.peek();
            if (!this.isFirstElementChecked) {
                if (!this.ROOT_NODE_NAME.equals(svName)) {
                    throw new RepositoryException("The first element must be root. But found '" + svName + "'");
                }
                this.isFirstElementChecked = true;
            }
            if (this.ROOT_NODE_NAME.equals(svName)) {
                currentNodeName = Constants.ROOT_PATH.getName();
                this.tree.pop();
                newNodeData = new ImportNodeData(Constants.ROOT_PATH, "00exo0jcr0root0uuid0000000000000", -1, Constants.NT_UNSTRUCTURED, new InternalQName[0], 0, null, new AccessControlList());
                this.changesLog.add(new ItemState(newNodeData, 1, true, parentData.getQPath(), false, false));
            } else {
                currentNodeName = this.locationFactory.parseJCRName(svName).getInternalName();
                nodeIndex = this.getNodeIndex(parentData, currentNodeName, null);
                newNodeData = new ImportNodeData(parentData, currentNodeName, nodeIndex);
                newNodeData.setOrderNumber(this.getNextChildOrderNum(parentData));
                newNodeData.setIdentifier(svId);
                this.changesLog.add(new ItemState(newNodeData, 1, true, parentData.getQPath()));
            }
            this.tree.push(newNodeData);
        } else {
            super.startElement(namespaceURI, localName, name, atts);
            if (Constants.SV_PROPERTY_NAME.equals((Object)elementName)) {
                String svId = this.getAttribute(atts, Constants.EXO_ID_NAME);
                if (svId == null) {
                    throw new RepositoryException("Missing mandatory exo:id attribute of element sv:property");
                }
                this.propertyInfo.setIndentifer(svId);
            }
        }
    }
}

