/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.InvalidItemStateException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValuesList;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitions;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.ItemDefinitionsHolder;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDataPersister;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypesHierarchyHolder;
import org.exoplatform.services.jcr.impl.core.nodetype.PropertyDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.WorkspaceNTManagerImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.util.EntityCollection;
import org.exoplatform.services.log.ExoLogger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeManagerImpl
implements ExtendedNodeTypeManager {
    protected static Log log = ExoLogger.getLogger((String)"jcr.NodeTypeManagerImpl");
    private static final String NODETYPES_FILE = "nodetypes.xml";
    public static final String NODETYPES_ROOT = "/jcr:system/jcr:nodetypes";
    private ValueFactory valueFactory;
    private LocationFactory locationFactory;
    private Map<InternalQName, ExtendedNodeType> nodeTypes;
    private String accessControlPolicy;
    private ItemDefinitionsHolder itemDefintionsHolder;
    private NamespaceRegistry namespaceRegistry = null;
    private NodeTypeDataPersister persister = null;

    public NodeTypeManagerImpl(RepositoryEntry config, LocationFactory locationFactory, ValueFactoryImpl valueFactory, NamespaceRegistry namespaceRegistry, NodeTypeDataPersister persister) throws RepositoryException {
        this(locationFactory, valueFactory, namespaceRegistry, config.getAccessControl(), persister, null);
        this.initDefault();
    }

    protected NodeTypeManagerImpl(LocationFactory locationFactory, ValueFactoryImpl valueFactory, NamespaceRegistry namespaceRegistry, String accessControlPolicy, NodeTypeDataPersister persister, Map<InternalQName, ExtendedNodeType> nodeTypes) {
        this.nodeTypes = nodeTypes != null ? nodeTypes : new LinkedHashMap();
        this.valueFactory = valueFactory;
        this.locationFactory = locationFactory;
        this.namespaceRegistry = namespaceRegistry;
        this.accessControlPolicy = accessControlPolicy;
        this.persister = persister;
        this.itemDefintionsHolder = new ItemDefinitionsHolder(new NodeTypesHierarchyHolder());
    }

    public WorkspaceNTManagerImpl createWorkspaceNTManager(SessionImpl session) throws RepositoryException {
        WorkspaceNTManagerImpl wntm = new WorkspaceNTManagerImpl(this.namespaceRegistry, this.accessControlPolicy, session, this.persister, this.nodeTypes);
        return wntm;
    }

    public NodeType getNodeType(String nodeTypeName) throws NoSuchNodeTypeException, RepositoryException {
        return this.getNodeType(this.locationFactory.parseJCRName(nodeTypeName).getInternalName());
    }

    @Override
    public ExtendedNodeType getNodeType(InternalQName qName) throws NoSuchNodeTypeException, RepositoryException {
        ExtendedNodeType nt = this.findNodeType(qName);
        if (nt != null) {
            return nt;
        }
        throw new NoSuchNodeTypeException("NodeTypeManager.getNodeType(): NodeType '" + qName.getAsString() + "' not found.");
    }

    public ExtendedNodeType findNodeType(InternalQName qName) {
        return this.nodeTypes.get((Object)qName);
    }

    public List<ExtendedNodeType> getNodeTypes(InternalQName primaryType, InternalQName[] mixinTypes) throws NoSuchNodeTypeException, RepositoryException {
        ExtendedNodeType primaryNt = this.findNodeType(primaryType);
        if (primaryNt == null) {
            throw new NoSuchNodeTypeException("Node (primary) type '" + primaryNt.getName() + "' is not found.");
        }
        ArrayList<ExtendedNodeType> nts = new ArrayList<ExtendedNodeType>();
        nts.add(primaryNt);
        if (mixinTypes != null) {
            for (InternalQName mixin : mixinTypes) {
                ExtendedNodeType mixinNt = this.findNodeType(mixin);
                if (mixinNt == null) {
                    throw new NoSuchNodeTypeException("Node (mixin) type '" + mixinNt.getName() + "' is not found.");
                }
                if (!mixinNt.isMixin()) {
                    throw new IllegalArgumentException("Node type '" + mixinNt.getName() + "' is not mixin.");
                }
                nts.add(mixinNt);
            }
        }
        return nts;
    }

    @Deprecated
    public PropertyDefinition findPropertyDefinition(InternalQName propertyName, List<ExtendedNodeType> typesList) throws RepositoryException {
        PropertyDefinition pdResidual = null;
        for (ExtendedNodeType nt : typesList) {
            PropertyDefinitions pds = nt.getPropertyDefinitions(propertyName);
            PropertyDefinition pd = pds.getAnyDefinition();
            if (pd == null) continue;
            if (((PropertyDefinitionImpl)pd).isResidualSet()) {
                pdResidual = pd;
                continue;
            }
            return pd;
        }
        if (pdResidual == null) {
            throw new RepositoryException("Property definition '" + propertyName.getAsString() + "' is not found.");
        }
        return pdResidual;
    }

    @Deprecated
    public PropertyDefinition findPropertyDefinition(InternalQName propertyName, InternalQName primaryType, InternalQName[] mixinTypes) throws RepositoryException {
        List<ExtendedNodeType> allTypes = this.getNodeTypes(primaryType, mixinTypes);
        return this.findPropertyDefinition(propertyName, allTypes);
    }

    public PropertyDefinitions findPropertyDefinitions(InternalQName propertyName, List<ExtendedNodeType> typesList) throws RepositoryException {
        PropertyDefinitions pdResidual = null;
        for (ExtendedNodeType nt : typesList) {
            PropertyDefinitions pds = nt.getPropertyDefinitions(propertyName);
            PropertyDefinitionImpl pd = (PropertyDefinitionImpl)pds.getAnyDefinition();
            if (pd == null) continue;
            if (pd.isResidualSet()) {
                pdResidual = pds;
                continue;
            }
            return pds;
        }
        if (pdResidual == null) {
            throw new RepositoryException("Property definition '" + propertyName.getAsString() + "' is not found.");
        }
        return pdResidual;
    }

    public PropertyDefinitions findPropertyDefinitions(InternalQName propertyName, InternalQName primaryType, InternalQName[] mixinTypes) throws RepositoryException {
        List<ExtendedNodeType> allTypes = this.getNodeTypes(primaryType, mixinTypes);
        return this.findPropertyDefinitions(propertyName, allTypes);
    }

    public NodeDefinitionImpl findNodeDefinition(InternalQName nodeName, List<ExtendedNodeType> typesList) throws RepositoryException {
        NodeDefinitionImpl ndResidual = null;
        for (ExtendedNodeType nt : typesList) {
            NodeDefinitionImpl nd = (NodeDefinitionImpl)nt.getChildNodeDefinition(nodeName);
            if (nd == null) continue;
            if (nd.isResidualSet()) {
                ndResidual = nd;
                continue;
            }
            return nd;
        }
        if (ndResidual == null) {
            throw new RepositoryException("Child node definition '" + nodeName.getAsString() + "' is not found.");
        }
        return ndResidual;
    }

    public NodeDefinitionImpl findNodeDefinition(InternalQName nodeName, InternalQName primaryType, InternalQName[] mixinTypes) throws RepositoryException {
        List<ExtendedNodeType> allTypes = this.getNodeTypes(primaryType, mixinTypes);
        return this.findNodeDefinition(nodeName, allTypes);
    }

    public boolean isOrderableChildNodesSupported(InternalQName primaryType, InternalQName[] mixinTypes) throws RepositoryException {
        for (ExtendedNodeType nt : this.getNodeTypes(primaryType, mixinTypes)) {
            if (!nt.hasOrderableChildNodes()) continue;
            return true;
        }
        return false;
    }

    public NodeTypeIterator getAllNodeTypes() {
        EntityCollection ec = new EntityCollection();
        ec.addAll(this.nodeTypes.values());
        return ec;
    }

    public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
        EntityCollection ec = new EntityCollection();
        NodeTypeIterator allTypes = this.getAllNodeTypes();
        while (allTypes.hasNext()) {
            NodeType type = allTypes.nextNodeType();
            if (type.isMixin()) continue;
            ec.add(type);
        }
        return ec;
    }

    public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
        EntityCollection ec = new EntityCollection();
        NodeTypeIterator allTypes = this.getAllNodeTypes();
        while (allTypes.hasNext()) {
            NodeType type = allTypes.nextNodeType();
            if (!type.isMixin()) continue;
            ec.add(type);
        }
        return ec;
    }

    @Override
    public void registerNodeType(ExtendedNodeType nodeType, int alreadyExistsBehaviour) throws RepositoryException {
        if (nodeType == null) {
            throw new RepositoryException("NodeType object " + nodeType + " is null");
        }
        long start = System.currentTimeMillis();
        if (this.accessControlPolicy.equals("disable") && nodeType.getName().equals("exo:privilegeable")) {
            throw new RepositoryException("NodeType exo:privilegeable is DISABLED");
        }
        InternalQName qname = nodeType.getQName();
        if (qname == null) {
            throw new RepositoryException("NodeType implementation class " + nodeType.getClass().getName() + " is not supported in this method");
        }
        if (this.findNodeType(qname) != null) {
            if (alreadyExistsBehaviour == 2) {
                throw new RepositoryException("NodeType " + nodeType.getName() + " is already registered");
            }
            log.warn((Object)("NodeType " + nodeType.getName() + " is already registered"));
            return;
        }
        this.nodeTypes.put(nodeType.getQName(), nodeType);
        if (this.persister.isPersisted()) {
            try {
                if (!this.persister.hasNodeTypeData(nodeType.getName())) {
                    this.persister.addNodeType(nodeType);
                    this.persister.saveChanges();
                }
            }
            catch (InvalidItemStateException e) {
                log.warn((Object)("Error of storing node type " + nodeType.getName() + ". May be node type already registered ."), (Throwable)e);
            }
            log.info((Object)("NodeType " + nodeType.getName() + " initialized. " + (System.currentTimeMillis() - start) + " ms"));
        } else {
            log.debug((Object)("NodeType " + nodeType.getName() + " registered but not initialized (storage is not initialized). " + (System.currentTimeMillis() - start) + " ms"));
        }
    }

    @Override
    public void registerNodeType(Class<ExtendedNodeType> nodeTypeType, int alreadyExistsBehaviour) throws RepositoryException, InstantiationException {
        this.registerNodeType((ExtendedNodeType)this.makeNtFromClass(nodeTypeType), alreadyExistsBehaviour);
    }

    @Override
    public void registerNodeType(NodeTypeValue nodeTypeValue, int alreadyExistsBehaviour) throws RepositoryException {
        List<String> nsupertypes;
        if (this.accessControlPolicy.equals("disable") && ((nsupertypes = nodeTypeValue.getDeclaredSupertypeNames()) != null && nsupertypes.contains("exo:privilegeable") || nodeTypeValue.getName().equals("exo:privilegeable"))) {
            log.warn((Object)("Node type " + nodeTypeValue.getName() + " is not register due to DISABLE control policy"));
            return;
        }
        nodeTypeValue.validateNodeType();
        NodeTypeImpl nodeType = new NodeTypeImpl(this, nodeTypeValue);
        this.registerNodeType(nodeType, alreadyExistsBehaviour);
    }

    @Override
    public void registerNodeTypes(InputStream xml, int alreadyExistsBehaviour) throws RepositoryException {
        try {
            IBindingFactory factory = BindingDirectory.getFactory(NodeTypeValuesList.class);
            IUnmarshallingContext uctx = factory.createUnmarshallingContext();
            NodeTypeValuesList nodeTypeValuesList = (NodeTypeValuesList)uctx.unmarshalDocument(xml, null);
            ArrayList ntvList = nodeTypeValuesList.getNodeTypeValuesList();
            long start = System.currentTimeMillis();
            for (int i = 0; i < ntvList.size(); ++i) {
                if (ntvList.get(i) != null) {
                    NodeTypeValue nodeTypeValue = (NodeTypeValue)ntvList.get(i);
                    this.registerNodeType(nodeTypeValue, alreadyExistsBehaviour);
                    continue;
                }
                log.error((Object)("Empty nodeTypeValue in xml document, index: " + i + ", skiping..."));
            }
            log.info((Object)("Nodetypes registered from xml definitions (count: " + ntvList.size() + "). " + (System.currentTimeMillis() - start) + " ms."));
        }
        catch (JiBXException e) {
            throw new RepositoryException("Error in config initialization " + (Object)((Object)e), (Throwable)e);
        }
    }

    private NodeType makeNtFromClass(Class<ExtendedNodeType> nodeTypeType) throws InstantiationException {
        try {
            Constructor<ExtendedNodeType> c = nodeTypeType.getConstructor(NodeTypeManager.class);
            return c.newInstance(this);
        }
        catch (Exception e1) {
            throw new InstantiationException("Error in making istance of " + nodeTypeType.getName() + ". Class should have been NodeType subclass and have constructor with one argument NodeTypeManager type. Reason: " + e1.getCause());
        }
    }

    private void initDefault() throws RepositoryException {
        block6: {
            long start = System.currentTimeMillis();
            try {
                InputStream xml = NodeTypeManagerImpl.class.getResourceAsStream(NODETYPES_FILE);
                if (xml != null) {
                    this.registerNodeTypes(xml, 0);
                    break block6;
                }
                String msg = "Resource file 'nodetypes.xml' with NodeTypes configuration does not found. Can not create node type manager";
                log.error((Object)msg);
                throw new RepositoryException(msg);
            }
            catch (Exception e) {
                String msg = "Error of initialization default types. Resource file with NodeTypes configuration 'nodetypes.xml'. " + e;
                log.error((Object)msg);
                throw new RepositoryException(msg, (Throwable)e);
            }
            finally {
                log.info((Object)("Initialization of default nodetypes done. " + (System.currentTimeMillis() - start) + " ms."));
            }
        }
    }

    public void loadFromStorage() throws RepositoryException {
        long start = System.currentTimeMillis();
        try {
            ArrayList<NodeType> rNodeTypes = new ArrayList<NodeType>();
            rNodeTypes.addAll(this.nodeTypes.values());
            List<NodeType> loadedNt = this.persister.loadNodetypes(rNodeTypes, this);
            for (NodeType nodeType : loadedNt) {
                this.nodeTypes.put(((ExtendedNodeType)nodeType).getQName(), (ExtendedNodeType)nodeType);
            }
            if (loadedNt.size() > 0) {
                log.info((Object)("NodeTypes (count: " + loadedNt.size() + ") loaded. " + (System.currentTimeMillis() - start) + " ms"));
            }
        }
        catch (PathNotFoundException e) {
            log.warn((Object)"NodeTypes storage (/jcr:system/jcr:nodetypes) is not initialized. Only default nodetypes is accessible");
            return;
        }
    }

    public boolean isNodeType(InternalQName testTypeName, InternalQName[] typeNames) {
        for (int i = 0; i < typeNames.length; ++i) {
            ExtendedNodeType testType;
            ExtendedNodeType subType;
            if (testTypeName.equals((Object)typeNames[i])) {
                return true;
            }
            try {
                subType = this.getNodeType(typeNames[i]);
                testType = this.getNodeType(testTypeName);
            }
            catch (RepositoryException e) {
                log.error((Object)("Error obtaining node type " + (Object)((Object)e)));
                continue;
            }
            NodeType[] superTypes = subType.getSupertypes();
            for (int j = 0; j < superTypes.length; ++j) {
                ExtendedNodeType testSuperType = (ExtendedNodeType)superTypes[j];
                if (!testSuperType.getQName().equals((Object)testType.getQName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNodeType(InternalQName testTypeName, InternalQName typeName, InternalQName[] typeNames) {
        if (this.isNodeType(testTypeName, typeName)) {
            return true;
        }
        for (InternalQName tname : typeNames) {
            if (!this.isNodeType(testTypeName, tname)) continue;
            return true;
        }
        return false;
    }

    public boolean isNodeType(InternalQName testTypeName, InternalQName typeName) {
        ExtendedNodeType testType;
        ExtendedNodeType subType;
        if (testTypeName.equals((Object)typeName)) {
            return true;
        }
        try {
            subType = this.getNodeType(typeName);
            testType = this.getNodeType(testTypeName);
        }
        catch (RepositoryException e) {
            log.error((Object)("Error obtaining node type " + (Object)((Object)e)));
            return false;
        }
        NodeType[] superTypes = subType.getSupertypes();
        for (int j = 0; j < superTypes.length; ++j) {
            ExtendedNodeType testSuperType = (ExtendedNodeType)superTypes[j];
            if (!testSuperType.getQName().equals((Object)testType.getQName())) continue;
            return true;
        }
        return false;
    }

    public LocationFactory getLocationFactory() {
        return this.locationFactory;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public ItemDefinitionsHolder getItemDefinitionsHolder() {
        return this.itemDefintionsHolder;
    }
}

