/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;

abstract class DocId {
    static final DocId NULL = new DocId(){

        final int getDocumentNumber(IndexReader reader) {
            return -1;
        }

        final DocId applyOffset(int offset) {
            return this;
        }

        final boolean isValid(BitSet deleted) {
            return true;
        }
    };

    DocId() {
    }

    abstract int getDocumentNumber(IndexReader var1) throws IOException;

    abstract DocId applyOffset(int var1);

    abstract boolean isValid(BitSet var1);

    static DocId create(int docNumber) {
        return new PlainDocId(docNumber);
    }

    static DocId create(String identifier) {
        return new IdentifierDocId(identifier);
    }

    private static final class IdentifierDocId
    extends DocId {
        private final String identifier;

        IdentifierDocId(String identifier) {
            this.identifier = identifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final int getDocumentNumber(IndexReader reader) throws IOException {
            Term id = new Term(FieldNames.UUID, this.identifier);
            TermDocs docs = reader.termDocs(id);
            int doc = -1;
            try {
                if (docs.next()) {
                    doc = docs.doc();
                }
            }
            finally {
                docs.close();
            }
            return doc;
        }

        final DocId applyOffset(int offset) {
            return this;
        }

        final boolean isValid(BitSet deleted) {
            return true;
        }

        public final String toString() {
            return "IdentifierDocId(" + this.identifier + ")";
        }
    }

    private static final class PlainDocId
    extends DocId {
        private final int docNumber;

        PlainDocId(int docNumber) {
            this.docNumber = docNumber;
        }

        final int getDocumentNumber(IndexReader reader) {
            return this.docNumber;
        }

        final DocId applyOffset(int offset) {
            return new PlainDocId(this.docNumber + offset);
        }

        final boolean isValid(BitSet deleted) {
            return !deleted.get(this.docNumber);
        }

        public final String toString() {
            return "PlainDocId(" + this.docNumber + ")";
        }
    }
}

